/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.io.function.Constants;
import org.apache.commons.io.function.Uncheck;

@FunctionalInterface
public interface IOPredicate<T> {
    public static <T> IOPredicate<T> alwaysFalse() {
        return Constants.IO_PREDICATE_FALSE;
    }

    public static <T> IOPredicate<T> alwaysTrue() {
        return Constants.IO_PREDICATE_TRUE;
    }

    public static <T> IOPredicate<T> isEqual(Object object) {
        if (object == null) {
            return Objects::isNull;
        }
        return object2 -> object.equals(object2);
    }

    default public IOPredicate<T> and(IOPredicate<? super T> iOPredicate) {
        Objects.requireNonNull(iOPredicate);
        return object -> this.test(object) && iOPredicate.test(object);
    }

    default public Predicate<T> asPredicate() {
        return object -> Uncheck.test(this, object);
    }

    default public IOPredicate<T> negate() {
        return object -> !this.test(object);
    }

    default public IOPredicate<T> or(IOPredicate<? super T> iOPredicate) {
        Objects.requireNonNull(iOPredicate);
        return object -> this.test(object) || iOPredicate.test(object);
    }

    public boolean test(T var1) throws IOException;
}

