/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.util.Objects;
import java.util.Spliterator;
import org.apache.commons.io.function.IOComparator;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOSpliteratorAdapter;
import org.apache.commons.io.function.UncheckedIOSpliterator;

public interface IOSpliterator<T> {
    public static <E> IOSpliterator<E> adapt(Spliterator<E> spliterator) {
        return IOSpliteratorAdapter.adapt(spliterator);
    }

    default public Spliterator<T> asSpliterator() {
        return new UncheckedIOSpliterator(this);
    }

    default public int characteristics() {
        return this.unwrap().characteristics();
    }

    default public long estimateSize() {
        return this.unwrap().estimateSize();
    }

    default public void forEachRemaining(IOConsumer<? super T> iOConsumer) {
        while (this.tryAdvance(iOConsumer)) {
        }
    }

    default public IOComparator<? super T> getComparator() {
        return (IOComparator)((Object)this.unwrap().getComparator());
    }

    default public long getExactSizeIfKnown() {
        return this.unwrap().getExactSizeIfKnown();
    }

    default public boolean hasCharacteristics(int n2) {
        return this.unwrap().hasCharacteristics(n2);
    }

    default public boolean tryAdvance(IOConsumer<? super T> iOConsumer) {
        return this.unwrap().tryAdvance(Objects.requireNonNull(iOConsumer, "action").asConsumer());
    }

    default public IOSpliterator<T> trySplit() {
        return IOSpliterator.adapt(this.unwrap().trySplit());
    }

    public Spliterator<T> unwrap();
}

