/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.function.Erase;
import org.apache.commons.io.function.IOBaseStream;
import org.apache.commons.io.function.IOBiConsumer;
import org.apache.commons.io.function.IOBiFunction;
import org.apache.commons.io.function.IOBinaryOperator;
import org.apache.commons.io.function.IOComparator;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOPredicate;
import org.apache.commons.io.function.IOStream$1;
import org.apache.commons.io.function.IOStreamAdapter;
import org.apache.commons.io.function.IOStreams;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.io.function.IOUnaryOperator;

public interface IOStream<T>
extends IOBaseStream<T, IOStream<T>, Stream<T>> {
    public static <T> IOStream<T> adapt(Stream<T> stream) {
        return IOStreamAdapter.adapt(stream);
    }

    public static <T> IOStream<T> empty() {
        return IOStreamAdapter.adapt(Stream.empty());
    }

    public static <T> IOStream<T> iterate(T object, IOUnaryOperator<T> iOUnaryOperator) {
        Objects.requireNonNull(iOUnaryOperator);
        object = new IOStream$1(object, iOUnaryOperator);
        return IOStream.adapt(StreamSupport.stream(Spliterators.spliteratorUnknownSize(object, 1040), false));
    }

    public static <T> IOStream<T> of(Iterable<T> iterable) {
        if (iterable == null) {
            return IOStream.empty();
        }
        return IOStream.adapt(StreamSupport.stream(iterable.spliterator(), false));
    }

    @SafeVarargs
    public static <T> IOStream<T> of(T ... TArray) {
        if (TArray == null || TArray.length == 0) {
            return IOStream.empty();
        }
        return IOStream.adapt(Arrays.stream(TArray));
    }

    public static <T> IOStream<T> of(T t2) {
        return IOStream.adapt(Stream.of(t2));
    }

    default public boolean allMatch(IOPredicate<? super T> iOPredicate) throws IOException {
        return ((Stream)this.unwrap()).allMatch((? super T object) -> Erase.test(iOPredicate, object));
    }

    default public boolean anyMatch(IOPredicate<? super T> iOPredicate) throws IOException {
        return ((Stream)this.unwrap()).anyMatch((? super T object) -> Erase.test(iOPredicate, object));
    }

    default public <R, A> R collect(Collector<? super T, A, R> collector) {
        return ((Stream)this.unwrap()).collect(collector);
    }

    default public <R> R collect(IOSupplier<R> iOSupplier, IOBiConsumer<R, ? super T> iOBiConsumer, IOBiConsumer<R, R> iOBiConsumer2) throws IOException {
        return (R)((Stream)this.unwrap()).collect(() -> Erase.get(iOSupplier), (R object, ? super T object2) -> Erase.accept(iOBiConsumer, object, object2), (R object, R object2) -> Erase.accept(iOBiConsumer2, object, object2));
    }

    default public long count() {
        return ((Stream)this.unwrap()).count();
    }

    default public IOStream<T> distinct() {
        return IOStream.adapt(((Stream)this.unwrap()).distinct());
    }

    default public IOStream<T> filter(IOPredicate<? super T> iOPredicate) throws IOException {
        return IOStream.adapt(((Stream)this.unwrap()).filter((? super T object) -> Erase.test(iOPredicate, object)));
    }

    default public Optional<T> findAny() {
        return ((Stream)this.unwrap()).findAny();
    }

    default public Optional<T> findFirst() {
        return ((Stream)this.unwrap()).findFirst();
    }

    default public <R> IOStream<R> flatMap(IOFunction<? super T, ? extends IOStream<? extends R>> iOFunction) throws IOException {
        return IOStream.adapt(((Stream)this.unwrap()).flatMap((? super T object) -> (Stream)((IOStream)Erase.apply(iOFunction, object)).unwrap()));
    }

    default public DoubleStream flatMapToDouble(IOFunction<? super T, ? extends DoubleStream> iOFunction) throws IOException {
        return ((Stream)this.unwrap()).flatMapToDouble((? super T object) -> (DoubleStream)Erase.apply(iOFunction, object));
    }

    default public IntStream flatMapToInt(IOFunction<? super T, ? extends IntStream> iOFunction) throws IOException {
        return ((Stream)this.unwrap()).flatMapToInt((? super T object) -> (IntStream)Erase.apply(iOFunction, object));
    }

    default public LongStream flatMapToLong(IOFunction<? super T, ? extends LongStream> iOFunction) throws IOException {
        return ((Stream)this.unwrap()).flatMapToLong((? super T object) -> (LongStream)Erase.apply(iOFunction, object));
    }

    default public void forAll(IOConsumer<T> iOConsumer) throws IOExceptionList {
        this.forAll(iOConsumer, (n2, iOException) -> iOException);
    }

    default public void forAll(IOConsumer<T> iOConsumer, BiFunction<Integer, IOException, IOException> biFunction) throws IOExceptionList {
        AtomicReference atomicReference = new AtomicReference();
        AtomicInteger atomicInteger = new AtomicInteger();
        iOConsumer = IOStreams.toIOConsumer(iOConsumer);
        ((Stream)this.unwrap()).forEach((? super T object) -> {
            block3: {
                try {
                    iOConsumer.accept(object);
                }
                catch (IOException iOException) {
                    if (atomicReference.get() == null) {
                        atomicReference.set(new ArrayList());
                    }
                    if (biFunction == null) break block3;
                    ((List)atomicReference.get()).add((IOException)biFunction.apply(atomicInteger.get(), iOException));
                }
            }
            atomicInteger.incrementAndGet();
        });
        IOExceptionList.checkEmpty((List)atomicReference.get(), null);
    }

    default public void forEach(IOConsumer<? super T> iOConsumer) throws IOException {
        ((Stream)this.unwrap()).forEach((? super T object) -> Erase.accept(iOConsumer, object));
    }

    default public void forEachOrdered(IOConsumer<? super T> iOConsumer) throws IOException {
        ((Stream)this.unwrap()).forEachOrdered((? super T object) -> Erase.accept(iOConsumer, object));
    }

    default public IOStream<T> limit(long l2) {
        return IOStream.adapt(((Stream)this.unwrap()).limit(l2));
    }

    default public <R> IOStream<R> map(IOFunction<? super T, ? extends R> iOFunction) throws IOException {
        return IOStream.adapt(((Stream)this.unwrap()).map((? super T object) -> Erase.apply(iOFunction, object)));
    }

    default public DoubleStream mapToDouble(ToDoubleFunction<? super T> toDoubleFunction) {
        return ((Stream)this.unwrap()).mapToDouble(toDoubleFunction);
    }

    default public IntStream mapToInt(ToIntFunction<? super T> toIntFunction) {
        return ((Stream)this.unwrap()).mapToInt(toIntFunction);
    }

    default public LongStream mapToLong(ToLongFunction<? super T> toLongFunction) {
        return ((Stream)this.unwrap()).mapToLong(toLongFunction);
    }

    default public Optional<T> max(IOComparator<? super T> iOComparator) throws IOException {
        return ((Stream)this.unwrap()).max((object, object2) -> Erase.compare(iOComparator, object, object2));
    }

    default public Optional<T> min(IOComparator<? super T> iOComparator) throws IOException {
        return ((Stream)this.unwrap()).min((object, object2) -> Erase.compare(iOComparator, object, object2));
    }

    default public boolean noneMatch(IOPredicate<? super T> iOPredicate) throws IOException {
        return ((Stream)this.unwrap()).noneMatch((? super T object) -> Erase.test(iOPredicate, object));
    }

    default public IOStream<T> peek(IOConsumer<? super T> iOConsumer) throws IOException {
        return IOStream.adapt(((Stream)this.unwrap()).peek((? super T object) -> Erase.accept(iOConsumer, object)));
    }

    default public Optional<T> reduce(IOBinaryOperator<T> iOBinaryOperator) throws IOException {
        return ((Stream)this.unwrap()).reduce((object, object2) -> Erase.apply(iOBinaryOperator, object, object2));
    }

    default public T reduce(T t2, IOBinaryOperator<T> iOBinaryOperator) throws IOException {
        return ((Stream)this.unwrap()).reduce(t2, (object, object2) -> Erase.apply(iOBinaryOperator, object, object2));
    }

    default public <U> U reduce(U u2, IOBiFunction<U, ? super T, U> iOBiFunction, IOBinaryOperator<U> iOBinaryOperator) throws IOException {
        return (U)((Stream)this.unwrap()).reduce(u2, (U object, ? super T object2) -> Erase.apply(iOBiFunction, object, object2), (object, object2) -> Erase.apply(iOBinaryOperator, object, object2));
    }

    default public IOStream<T> skip(long l2) {
        return IOStream.adapt(((Stream)this.unwrap()).skip(l2));
    }

    default public IOStream<T> sorted() {
        return IOStream.adapt(((Stream)this.unwrap()).sorted());
    }

    default public IOStream<T> sorted(IOComparator<? super T> iOComparator) throws IOException {
        return IOStream.adapt(((Stream)this.unwrap()).sorted((object, object2) -> Erase.compare(iOComparator, object, object2)));
    }

    default public Object[] toArray() {
        return ((Stream)this.unwrap()).toArray();
    }

    default public <A> A[] toArray(IntFunction<A[]> intFunction) {
        return ((Stream)this.unwrap()).toArray(intFunction);
    }
}

