/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.IOIndexedException;
import org.apache.commons.io.function.Erase;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOStream;

final class IOStreams {
    static final Object NONE = new Object();

    static <T> void forAll(Stream<T> stream, IOConsumer<T> iOConsumer) throws IOExceptionList {
        IOStreams.forAll(stream, iOConsumer, (n2, iOException) -> iOException);
    }

    static <T> void forAll(Stream<T> stream, IOConsumer<T> iOConsumer, BiFunction<Integer, IOException, IOException> biFunction) throws IOExceptionList {
        IOStream.adapt(stream).forAll(iOConsumer, IOIndexedException::new);
    }

    static <T> void forEach(Stream<T> stream, IOConsumer<T> iOConsumer) throws IOException {
        iOConsumer = IOStreams.toIOConsumer(iOConsumer);
        IOStreams.of(stream).forEach(object -> Erase.accept(iOConsumer, object));
    }

    static <T> Stream<T> of(Iterable<T> iterable) {
        if (iterable == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    static <T> Stream<T> of(Stream<T> stream) {
        if (stream == null) {
            return Stream.empty();
        }
        return stream;
    }

    @SafeVarargs
    static <T> Stream<T> of(T ... TArray) {
        if (TArray == null) {
            return Stream.empty();
        }
        return Stream.of(TArray);
    }

    static <T> IOConsumer<T> toIOConsumer(IOConsumer<T> iOConsumer) {
        if (iOConsumer != null) {
            return iOConsumer;
        }
        return IOConsumer.noop();
    }

    private IOStreams() {
    }
}

