/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.io.function.IOIterator;
import org.apache.commons.io.function.Uncheck;

final class UncheckedIOIterator<E>
implements Iterator<E> {
    private final IOIterator<E> delegate;

    UncheckedIOIterator(IOIterator<E> iOIterator) {
        this.delegate = Objects.requireNonNull(iOIterator, "delegate");
    }

    @Override
    public final boolean hasNext() {
        return Uncheck.getAsBoolean(this.delegate::hasNext);
    }

    @Override
    public final E next() {
        return (E)Uncheck.get(this.delegate::next);
    }

    @Override
    public final void remove() {
        Uncheck.run(this.delegate::remove);
    }
}

