/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.commons.io.function.IOSpliterator;
import org.apache.commons.io.function.Uncheck;

final class UncheckedIOSpliterator<T>
implements Spliterator<T> {
    private final IOSpliterator<T> delegate;

    UncheckedIOSpliterator(IOSpliterator<T> iOSpliterator) {
        this.delegate = Objects.requireNonNull(iOSpliterator, "delegate");
    }

    @Override
    public final int characteristics() {
        return this.delegate.characteristics();
    }

    @Override
    public final long estimateSize() {
        return this.delegate.estimateSize();
    }

    @Override
    public final void forEachRemaining(Consumer<? super T> consumer) {
        Uncheck.accept(this.delegate::forEachRemaining, consumer::accept);
    }

    @Override
    public final Comparator<? super T> getComparator() {
        return this.delegate.getComparator().asComparator();
    }

    @Override
    public final long getExactSizeIfKnown() {
        return this.delegate.getExactSizeIfKnown();
    }

    @Override
    public final boolean hasCharacteristics(int n2) {
        return this.delegate.hasCharacteristics(n2);
    }

    @Override
    public final boolean tryAdvance(Consumer<? super T> consumer) {
        return Uncheck.apply(this.delegate::tryAdvance, consumer::accept);
    }

    @Override
    public final Spliterator<T> trySplit() {
        return Uncheck.get(this.delegate::trySplit).unwrap();
    }
}

