/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream$1;
import org.apache.commons.io.input.BOMInputStream$Builder;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.input.ProxyInputStream$AbstractBuilder;

public class BOMInputStream
extends ProxyInputStream {
    private static final Comparator<ByteOrderMark> ByteOrderMarkLengthComparator = Comparator.comparing(ByteOrderMark::length).reversed();
    private final List<ByteOrderMark> bomList;
    private ByteOrderMark byteOrderMark;
    private int fbIndex;
    private int[] firstBytes;
    private final boolean include;
    private boolean markedAtStart;
    private int markFbIndex;

    public static BOMInputStream$Builder builder() {
        return new BOMInputStream$Builder();
    }

    private BOMInputStream(BOMInputStream$Builder object) throws IOException {
        super((ProxyInputStream$AbstractBuilder<?, ?>)object);
        if (IOUtils.length(BOMInputStream$Builder.access$100((BOMInputStream$Builder)object)) == 0) {
            throw new IllegalArgumentException("No ByteOrderMark specified.");
        }
        this.include = BOMInputStream$Builder.access$200((BOMInputStream$Builder)object);
        object = Arrays.asList(BOMInputStream$Builder.access$100((BOMInputStream$Builder)object));
        object.sort(ByteOrderMarkLengthComparator);
        this.bomList = object;
    }

    @Deprecated
    public BOMInputStream(InputStream inputStream) {
        this(inputStream, false, BOMInputStream$Builder.access$300());
    }

    @Deprecated
    public BOMInputStream(InputStream inputStream, boolean bl2) {
        this(inputStream, bl2, BOMInputStream$Builder.access$300());
    }

    @Deprecated
    public BOMInputStream(InputStream object, boolean bl2, ByteOrderMark ... byteOrderMarkArray) {
        super((InputStream)object);
        if (IOUtils.length(byteOrderMarkArray) == 0) {
            throw new IllegalArgumentException("No BOMs specified");
        }
        this.include = bl2;
        object = Arrays.asList(byteOrderMarkArray);
        object.sort(ByteOrderMarkLengthComparator);
        this.bomList = object;
    }

    @Deprecated
    public BOMInputStream(InputStream inputStream, ByteOrderMark ... byteOrderMarkArray) {
        this(inputStream, false, byteOrderMarkArray);
    }

    private ByteOrderMark find() {
        return this.bomList.stream().filter(this::matches).findFirst().orElse(null);
    }

    public ByteOrderMark getBOM() throws IOException {
        if (this.firstBytes == null) {
            this.byteOrderMark = this.readBom();
        }
        return this.byteOrderMark;
    }

    public String getBOMCharsetName() throws IOException {
        this.getBOM();
        if (this.byteOrderMark == null) {
            return null;
        }
        return this.byteOrderMark.getCharsetName();
    }

    public boolean hasBOM() throws IOException {
        return this.getBOM() != null;
    }

    public boolean hasBOM(ByteOrderMark byteOrderMark) throws IOException {
        if (!this.bomList.contains(byteOrderMark)) {
            throw new IllegalArgumentException("Stream not configured to detect " + byteOrderMark);
        }
        return Objects.equals(this.getBOM(), byteOrderMark);
    }

    @Override
    public synchronized void mark(int n2) {
        this.markFbIndex = this.fbIndex;
        this.markedAtStart = this.firstBytes == null;
        this.in.mark(n2);
    }

    private boolean matches(ByteOrderMark byteOrderMark) {
        return byteOrderMark.matches(this.firstBytes);
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        int n2 = this.readFirstBytes();
        if (n2 >= 0) {
            return n2;
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return ((ProxyInputStream)this).read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        while (n3 > 0 && n5 >= 0) {
            n5 = this.readFirstBytes();
            if (n5 < 0) continue;
            byArray[n2++] = (byte)n5;
            --n3;
            ++n4;
        }
        int n6 = this.in.read(byArray, n2, n3);
        this.afterRead(n6);
        if (n6 < 0) {
            if (n4 > 0) {
                return n4;
            }
            return -1;
        }
        return n4 + n6;
    }

    private ByteOrderMark readBom() throws IOException {
        int n2 = 0;
        int n3 = this.bomList.get(0).length();
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.in.read();
            this.afterRead(nArray[i2]);
            ++n2;
            if (nArray[i2] < 0) break;
        }
        this.firstBytes = Arrays.copyOf(nArray, n2);
        ByteOrderMark byteOrderMark = this.find();
        if (byteOrderMark != null && !this.include) {
            if (byteOrderMark.length() < this.firstBytes.length) {
                this.fbIndex = byteOrderMark.length();
            } else {
                this.firstBytes = new int[0];
            }
        }
        return byteOrderMark;
    }

    private int readFirstBytes() throws IOException {
        this.getBOM();
        if (this.fbIndex < this.firstBytes.length) {
            return this.firstBytes[this.fbIndex++];
        }
        return -1;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.fbIndex = this.markFbIndex;
        if (this.markedAtStart) {
            this.firstBytes = null;
        }
        this.in.reset();
    }

    @Override
    public long skip(long l2) throws IOException {
        int n2 = 0;
        while (l2 > (long)n2 && this.readFirstBytes() >= 0) {
            ++n2;
        }
        return this.in.skip(l2 - (long)n2) + (long)n2;
    }

    /* synthetic */ BOMInputStream(BOMInputStream$Builder bOMInputStream$Builder, BOMInputStream$1 bOMInputStream$1) throws IOException {
        this(bOMInputStream$Builder);
    }
}

