/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import org.apache.commons.io.function.Erase;

public class BrokenInputStream
extends InputStream {
    public static final BrokenInputStream INSTANCE = new BrokenInputStream();
    private final Supplier<Throwable> exceptionSupplier;

    public BrokenInputStream() {
        this(() -> new IOException("Broken input stream"));
    }

    @Deprecated
    public BrokenInputStream(IOException iOException) {
        this(() -> iOException);
    }

    public BrokenInputStream(Supplier<Throwable> supplier) {
        this.exceptionSupplier = supplier;
    }

    public BrokenInputStream(Throwable throwable) {
        this(() -> throwable);
    }

    @Override
    public int available() throws IOException {
        throw this.rethrow();
    }

    @Override
    public void close() throws IOException {
        throw this.rethrow();
    }

    Throwable getThrowable() {
        return this.exceptionSupplier.get();
    }

    @Override
    public int read() throws IOException {
        throw this.rethrow();
    }

    @Override
    public synchronized void reset() throws IOException {
        throw this.rethrow();
    }

    private RuntimeException rethrow() {
        return Erase.rethrow(this.getThrowable());
    }

    @Override
    public long skip(long l2) throws IOException {
        throw this.rethrow();
    }
}

