/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.input.AbstractInputStream;
import org.apache.commons.io.input.ByteBufferCleaner;
import org.apache.commons.io.input.MemoryMappedFileInputStream$1;
import org.apache.commons.io.input.MemoryMappedFileInputStream$Builder;

public final class MemoryMappedFileInputStream
extends AbstractInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 262144;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]).asReadOnlyBuffer();
    private final int bufferSize;
    private final FileChannel channel;
    private ByteBuffer buffer = EMPTY_BUFFER;
    private long nextBufferPosition;

    public static MemoryMappedFileInputStream$Builder builder() {
        return new MemoryMappedFileInputStream$Builder();
    }

    private MemoryMappedFileInputStream(MemoryMappedFileInputStream$Builder memoryMappedFileInputStream$Builder) throws IOException {
        this.bufferSize = memoryMappedFileInputStream$Builder.getBufferSize();
        this.channel = FileChannel.open(memoryMappedFileInputStream$Builder.getPath(), StandardOpenOption.READ);
    }

    @Override
    public final int available() throws IOException {
        return this.buffer.remaining();
    }

    private void cleanBuffer() {
        if (ByteBufferCleaner.isSupported() && this.buffer.isDirect()) {
            ByteBufferCleaner.clean(this.buffer);
        }
    }

    @Override
    public final void close() throws IOException {
        if (!this.isClosed()) {
            this.cleanBuffer();
            this.buffer = EMPTY_BUFFER;
            this.channel.close();
            super.close();
        }
    }

    final int getBufferSize() {
        return this.bufferSize;
    }

    private void nextBuffer() throws IOException {
        long l2 = this.channel.size() - this.nextBufferPosition;
        if (l2 > 0L) {
            long l3 = Math.min(l2, (long)this.bufferSize);
            this.cleanBuffer();
            this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.nextBufferPosition, l3);
            this.nextBufferPosition += l3;
            return;
        }
        this.buffer = EMPTY_BUFFER;
    }

    @Override
    public final int read() throws IOException {
        this.checkOpen();
        if (!this.buffer.hasRemaining()) {
            this.nextBuffer();
            if (!this.buffer.hasRemaining()) {
                return -1;
            }
        }
        return Short.toUnsignedInt(this.buffer.get());
    }

    @Override
    public final int read(byte[] byArray, int n2, int n3) throws IOException {
        this.checkOpen();
        if (!this.buffer.hasRemaining()) {
            this.nextBuffer();
            if (!this.buffer.hasRemaining()) {
                return -1;
            }
        }
        n3 = Math.min(this.buffer.remaining(), n3);
        this.buffer.get(byArray, n2, n3);
        return n3;
    }

    @Override
    public final long skip(long l2) throws IOException {
        this.checkOpen();
        if (l2 <= 0L) {
            return 0L;
        }
        if (l2 <= (long)this.buffer.remaining()) {
            this.buffer.position((int)((long)this.buffer.position() + l2));
            return l2;
        }
        long l3 = this.channel.size() - this.nextBufferPosition;
        long l4 = (long)this.buffer.remaining() + Math.min(l3, l2 - (long)this.buffer.remaining());
        this.nextBufferPosition += l4 - (long)this.buffer.remaining();
        this.nextBuffer();
        return l4;
    }

    /* synthetic */ MemoryMappedFileInputStream(MemoryMappedFileInputStream$Builder memoryMappedFileInputStream$Builder, MemoryMappedFileInputStream$1 memoryMappedFileInputStream$1) throws IOException {
        this(memoryMappedFileInputStream$Builder);
    }
}

