/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.EOFException;
import java.io.IOException;
import org.apache.commons.io.input.AbstractInputStream;
import org.apache.commons.io.input.UnsupportedOperationExceptions;

public class NullInputStream
extends AbstractInputStream {
    @Deprecated
    public static final NullInputStream INSTANCE = new NullInputStream();
    private final long size;
    private long position;
    private long mark = -1L;
    private long readLimit;
    private final boolean throwEofException;
    private final boolean markSupported;

    public NullInputStream() {
        this(0L, true, false);
    }

    public NullInputStream(long l2) {
        this(l2, true, false);
    }

    public NullInputStream(long l2, boolean bl2, boolean bl3) {
        this.size = l2;
        this.markSupported = bl2;
        this.throwEofException = bl3;
    }

    @Override
    public int available() {
        if (this.isClosed()) {
            return 0;
        }
        long l2 = this.size - this.position;
        if (l2 <= 0L) {
            return 0;
        }
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    private void checkThrowEof(String string) throws EOFException {
        if (this.throwEofException) {
            throw new EOFException(string);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.mark = -1L;
    }

    public long getPosition() {
        return this.position;
    }

    public long getSize() {
        return this.size;
    }

    private int handleEof() throws IOException {
        this.checkThrowEof("handleEof()");
        return -1;
    }

    public NullInputStream init() {
        this.setClosed(false);
        this.position = 0L;
        this.mark = -1L;
        this.readLimit = 0L;
        return this;
    }

    @Override
    public synchronized void mark(int n2) {
        if (!this.markSupported) {
            throw UnsupportedOperationExceptions.mark();
        }
        this.mark = this.position;
        this.readLimit = n2;
    }

    @Override
    public boolean markSupported() {
        return this.markSupported;
    }

    protected int processByte() {
        return 0;
    }

    protected void processBytes(byte[] byArray, int n2, int n3) {
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        if (this.position == this.size) {
            return this.handleEof();
        }
        ++this.position;
        return this.processByte();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray.length == 0 || n3 == 0) {
            return 0;
        }
        this.checkOpen();
        if (this.position == this.size) {
            return this.handleEof();
        }
        this.position += (long)n3;
        int n4 = n3;
        if (this.position > this.size) {
            n4 = n3 - (int)(this.position - this.size);
            this.position = this.size;
        }
        this.processBytes(byArray, n2, n4);
        return n4;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.markSupported) {
            throw UnsupportedOperationExceptions.reset();
        }
        if (this.mark < 0L) {
            throw new IOException("No position has been marked");
        }
        if (this.position > this.mark + this.readLimit) {
            throw new IOException("Marked position [" + this.mark + "] is no longer valid - passed the read limit [" + this.readLimit + "]");
        }
        this.position = this.mark;
        this.setClosed(false);
    }

    @Override
    public long skip(long l2) throws IOException {
        if (this.isClosed()) {
            this.checkThrowEof("skip(long)");
            return -1L;
        }
        if (this.position == this.size) {
            return this.handleEof();
        }
        this.position += l2;
        long l3 = l2;
        if (this.position > this.size) {
            l3 = l2 - (this.position - this.size);
            this.position = this.size;
        }
        return l3;
    }
}

