/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.input.ObservableInputStream$AbstractBuilder;
import org.apache.commons.io.input.ObservableInputStream$Observer;
import org.apache.commons.io.input.ProxyInputStream;

public class ObservableInputStream
extends ProxyInputStream {
    private final List<ObservableInputStream$Observer> observers;

    ObservableInputStream(ObservableInputStream$AbstractBuilder<?> observableInputStream$AbstractBuilder) throws IOException {
        super(observableInputStream$AbstractBuilder);
        this.observers = ObservableInputStream$AbstractBuilder.access$000(observableInputStream$AbstractBuilder);
    }

    public ObservableInputStream(InputStream inputStream) {
        this(inputStream, new ArrayList<ObservableInputStream$Observer>());
    }

    private ObservableInputStream(InputStream inputStream, List<ObservableInputStream$Observer> list) {
        super(inputStream);
        this.observers = list;
    }

    public ObservableInputStream(InputStream inputStream, ObservableInputStream$Observer ... observableInputStream$ObserverArray) {
        this(inputStream, Arrays.asList(observableInputStream$ObserverArray));
    }

    public void add(ObservableInputStream$Observer observableInputStream$Observer) {
        this.observers.add(observableInputStream$Observer);
    }

    @Override
    public void close() throws IOException {
        IOException iOException = null;
        try {
            super.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            iOException = iOException2;
        }
        if (iOException == null) {
            this.noteClosed();
            return;
        }
        this.noteError(iOException);
    }

    public void consume() throws IOException {
        IOUtils.consume(this);
    }

    private void forEachObserver(IOConsumer<ObservableInputStream$Observer> iOConsumer) throws IOException {
        IOConsumer.forAll(iOConsumer, this.observers);
    }

    public List<ObservableInputStream$Observer> getObservers() {
        return new ArrayList<ObservableInputStream$Observer>(this.observers);
    }

    protected void noteClosed() throws IOException {
        this.forEachObserver(ObservableInputStream$Observer::closed);
    }

    protected void noteDataByte(int n2) throws IOException {
        this.forEachObserver(observableInputStream$Observer -> observableInputStream$Observer.data(n2));
    }

    protected void noteDataBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.forEachObserver(observableInputStream$Observer -> observableInputStream$Observer.data(byArray, n2, n3));
    }

    protected void noteError(IOException iOException) throws IOException {
        this.forEachObserver(observableInputStream$Observer -> observableInputStream$Observer.error(iOException));
    }

    protected void noteFinished() throws IOException {
        this.forEachObserver(ObservableInputStream$Observer::finished);
    }

    private void notify(byte[] byArray, int n2, int n3, IOException iOException) throws IOException {
        if (iOException != null) {
            this.noteError(iOException);
            throw iOException;
        }
        if (n3 == -1) {
            this.noteFinished();
            return;
        }
        if (n3 > 0) {
            this.noteDataBytes(byArray, n2, n3);
        }
    }

    @Override
    public int read() throws IOException {
        int n2 = 0;
        IOException iOException = null;
        try {
            n2 = super.read();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            iOException = iOException2;
        }
        if (iOException != null) {
            this.noteError(iOException);
            throw iOException;
        }
        if (n2 == -1) {
            this.noteFinished();
        } else {
            this.noteDataByte(n2);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n2 = 0;
        IOException iOException = null;
        try {
            n2 = super.read(byArray);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            iOException = iOException2;
        }
        this.notify(byArray, 0, n2, iOException);
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        IOException iOException = null;
        try {
            n4 = super.read(byArray, n2, n3);
        }
        catch (IOException iOException2) {
            IOException iOException3 = iOException2;
            iOException = iOException2;
        }
        this.notify(byArray, n2, n4, iOException);
        return n4;
    }

    public void remove(ObservableInputStream$Observer observableInputStream$Observer) {
        this.observers.remove(observableInputStream$Observer);
    }

    public void removeAllObservers() {
        this.observers.clear();
    }
}

