/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.InputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.input.QueueInputStream$1;
import org.apache.commons.io.input.QueueInputStream$Builder;
import org.apache.commons.io.output.QueueOutputStream;

public class QueueInputStream
extends InputStream {
    private final BlockingQueue<Integer> blockingQueue;
    private final long timeoutNanos;

    public static QueueInputStream$Builder builder() {
        return new QueueInputStream$Builder();
    }

    public QueueInputStream() {
        this(new LinkedBlockingQueue<Integer>());
    }

    @Deprecated
    public QueueInputStream(BlockingQueue<Integer> blockingQueue) {
        this(QueueInputStream.builder().setBlockingQueue(blockingQueue));
    }

    private QueueInputStream(QueueInputStream$Builder queueInputStream$Builder) {
        this.blockingQueue = Objects.requireNonNull(QueueInputStream$Builder.access$100(queueInputStream$Builder), "blockingQueue");
        this.timeoutNanos = Objects.requireNonNull(QueueInputStream$Builder.access$200(queueInputStream$Builder), "timeout").toNanos();
    }

    BlockingQueue<Integer> getBlockingQueue() {
        return this.blockingQueue;
    }

    Duration getTimeout() {
        return Duration.ofNanos(this.timeoutNanos);
    }

    public QueueOutputStream newQueueOutputStream() {
        return new QueueOutputStream(this.blockingQueue);
    }

    @Override
    public int read() {
        try {
            Integer n2 = this.blockingQueue.poll(this.timeoutNanos, TimeUnit.NANOSECONDS);
            if (n2 == null) {
                return -1;
            }
            return 0xFF & n2;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(interruptedException);
        }
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException(String.format("Range [%d, %<d + %d) out of bounds for length %d", n2, n3, byArray.length));
        }
        if (n3 == 0) {
            return 0;
        }
        Serializable serializable = new ArrayList<Integer>(Math.min(n3, this.blockingQueue.size()));
        this.blockingQueue.drainTo((Collection<Integer>)((Object)serializable), n3);
        if (serializable.isEmpty()) {
            n4 = this.read();
            if (n4 == -1) {
                return -1;
            }
            serializable.add(n4);
            this.blockingQueue.drainTo((Collection<Integer>)((Object)serializable), n3 - 1);
        }
        n4 = 0;
        Iterator iterator = serializable.iterator();
        while (iterator.hasNext()) {
            serializable = (Integer)iterator.next();
            byArray[n2 + n4] = (byte)(0xFF & (Integer)serializable);
            ++n4;
        }
        return n4;
    }

    /* synthetic */ QueueInputStream(QueueInputStream$Builder queueInputStream$Builder, QueueInputStream$1 queueInputStream$1) {
        this(queueInputStream$Builder);
    }
}

