/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Objects;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.charset.CharsetEncoders;
import org.apache.commons.io.input.AbstractInputStream;
import org.apache.commons.io.input.ReaderInputStream$1;
import org.apache.commons.io.input.ReaderInputStream$Builder;

public class ReaderInputStream
extends AbstractInputStream {
    private final Reader reader;
    private final CharsetEncoder charsetEncoder;
    private final CharBuffer encoderIn;
    private final ByteBuffer encoderOut;
    private CoderResult lastCoderResult;
    private boolean endOfInput;

    public static ReaderInputStream$Builder builder() {
        return new ReaderInputStream$Builder();
    }

    static int checkMinBufferSize(CharsetEncoder charsetEncoder, int n2) {
        float f2 = ReaderInputStream.minBufferSize(charsetEncoder);
        if ((float)n2 < f2) {
            throw new IllegalArgumentException(String.format("Buffer size %,d must be at least %s for a CharsetEncoder %s.", n2, Float.valueOf(f2), charsetEncoder.charset().displayName()));
        }
        return n2;
    }

    static float minBufferSize(CharsetEncoder charsetEncoder) {
        return charsetEncoder.maxBytesPerChar() * 2.0f;
    }

    private static CharsetEncoder newEncoder(Charset charset) {
        return Charsets.toCharset(charset).newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    private ReaderInputStream(ReaderInputStream$Builder readerInputStream$Builder) throws IOException {
        this(readerInputStream$Builder.getReader(), ReaderInputStream$Builder.access$200(readerInputStream$Builder), readerInputStream$Builder.getBufferSize());
    }

    @Deprecated
    public ReaderInputStream(Reader reader) {
        this(reader, Charset.defaultCharset());
    }

    @Deprecated
    public ReaderInputStream(Reader reader, Charset charset) {
        this(reader, charset, 8192);
    }

    @Deprecated
    public ReaderInputStream(Reader reader, Charset charset, int n2) {
        this(reader, Charsets.toCharset(charset).newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE), n2);
    }

    @Deprecated
    public ReaderInputStream(Reader reader, CharsetEncoder charsetEncoder) {
        this(reader, charsetEncoder, 8192);
    }

    @Deprecated
    public ReaderInputStream(Reader reader, CharsetEncoder charsetEncoder, int n2) {
        this.reader = reader;
        this.charsetEncoder = CharsetEncoders.toCharsetEncoder(charsetEncoder);
        this.encoderIn = CharBuffer.allocate(ReaderInputStream.checkMinBufferSize(this.charsetEncoder, n2));
        this.encoderIn.flip();
        this.encoderOut = ByteBuffer.allocate(128);
        this.encoderOut.flip();
    }

    @Deprecated
    public ReaderInputStream(Reader reader, String string) {
        this(reader, string, 8192);
    }

    @Deprecated
    public ReaderInputStream(Reader reader, String string, int n2) {
        this(reader, Charsets.toCharset(string), n2);
    }

    @Override
    public int available() throws IOException {
        if (this.encoderOut.hasRemaining()) {
            return this.encoderOut.remaining();
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        super.close();
    }

    private void fillBuffer() throws IOException {
        if (this.endOfInput) {
            return;
        }
        if (!this.endOfInput && (this.lastCoderResult == null || this.lastCoderResult.isUnderflow())) {
            this.encoderIn.compact();
            int n2 = this.encoderIn.position();
            int n3 = this.reader.read(this.encoderIn.array(), n2, this.encoderIn.remaining());
            if (n3 == -1) {
                this.endOfInput = true;
            } else {
                this.encoderIn.position(n2 + n3);
            }
            this.encoderIn.flip();
        }
        this.encoderOut.compact();
        this.lastCoderResult = this.charsetEncoder.encode(this.encoderIn, this.encoderOut, this.endOfInput);
        if (this.endOfInput) {
            this.lastCoderResult = this.charsetEncoder.flush(this.encoderOut);
        }
        if (this.lastCoderResult.isError()) {
            this.lastCoderResult.throwException();
        }
        this.encoderOut.flip();
    }

    CharsetEncoder getCharsetEncoder() {
        return this.charsetEncoder;
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        do {
            if (this.encoderOut.hasRemaining()) {
                return this.encoderOut.get() & 0xFF;
            }
            this.fillBuffer();
        } while (!this.endOfInput || this.encoderOut.hasRemaining());
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        Objects.requireNonNull(byArray, "array");
        if (n3 < 0 || n2 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("Array size=" + byArray.length + ", offset=" + n2 + ", length=" + n3);
        }
        int n4 = 0;
        if (n3 == 0) {
            return 0;
        }
        while (n3 > 0) {
            if (this.encoderOut.hasRemaining()) {
                int n5 = Math.min(this.encoderOut.remaining(), n3);
                this.encoderOut.get(byArray, n2, n5);
                n2 += n5;
                n3 -= n5;
                n4 += n5;
                continue;
            }
            if (this.endOfInput) break;
            this.fillBuffer();
        }
        if (n4 == 0 && this.endOfInput) {
            return -1;
        }
        return n4;
    }

    static /* synthetic */ CharsetEncoder access$000(Charset charset) {
        return ReaderInputStream.newEncoder(charset);
    }

    /* synthetic */ ReaderInputStream(ReaderInputStream$Builder readerInputStream$Builder, ReaderInputStream$1 readerInputStream$1) throws IOException {
        this(readerInputStream$Builder);
    }
}

