/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.EndianUtils;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.input.UnsupportedOperationExceptions;

public class SwappedDataInputStream
extends ProxyInputStream
implements DataInput {
    public SwappedDataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public boolean readBoolean() throws IOException, EOFException {
        return 0 != this.readByte();
    }

    @Override
    public byte readByte() throws IOException, EOFException {
        return (byte)this.in.read();
    }

    @Override
    public char readChar() throws IOException, EOFException {
        return (char)this.readShort();
    }

    @Override
    public double readDouble() throws IOException, EOFException {
        return EndianUtils.readSwappedDouble(this.in);
    }

    @Override
    public float readFloat() throws IOException, EOFException {
        return EndianUtils.readSwappedFloat(this.in);
    }

    @Override
    public void readFully(byte[] byArray) throws IOException, EOFException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n2, int n3) throws IOException, EOFException {
        int n4;
        for (int i2 = n3; i2 > 0; i2 -= n4) {
            n4 = n2 + n3 - i2;
            if (-1 != (n4 = this.read(byArray, n4, i2))) continue;
            throw new EOFException();
        }
    }

    @Override
    public int readInt() throws IOException, EOFException {
        return EndianUtils.readSwappedInteger(this.in);
    }

    @Override
    public String readLine() throws IOException, EOFException {
        throw UnsupportedOperationExceptions.method("readLine");
    }

    @Override
    public long readLong() throws IOException, EOFException {
        return EndianUtils.readSwappedLong(this.in);
    }

    @Override
    public short readShort() throws IOException, EOFException {
        return EndianUtils.readSwappedShort(this.in);
    }

    @Override
    public int readUnsignedByte() throws IOException, EOFException {
        return this.in.read();
    }

    @Override
    public int readUnsignedShort() throws IOException, EOFException {
        return EndianUtils.readSwappedUnsignedShort(this.in);
    }

    @Override
    public String readUTF() throws IOException, EOFException {
        throw UnsupportedOperationExceptions.method("readUTF");
    }

    @Override
    public int skipBytes(int n2) throws IOException {
        return (int)this.in.skip(n2);
    }
}

