/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.ProxyInputStream;

public class TeeInputStream
extends ProxyInputStream {
    private final OutputStream branch;
    private final boolean closeBranch;

    public TeeInputStream(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, false);
    }

    public TeeInputStream(InputStream inputStream, OutputStream outputStream, boolean bl2) {
        super(inputStream);
        this.branch = outputStream;
        this.closeBranch = bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
            if (!this.closeBranch) return;
        }
        catch (Throwable throwable) {
            if (!this.closeBranch) throw throwable;
            this.branch.close();
            throw throwable;
        }
        this.branch.close();
    }

    @Override
    public int read() throws IOException {
        int n2 = super.read();
        if (n2 != -1) {
            this.branch.write(n2);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n2 = super.read(byArray);
        if (n2 != -1) {
            this.branch.write(byArray, 0, n2);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if ((n3 = super.read(byArray, n2, n3)) != -1) {
            this.branch.write(byArray, n2, n3);
        }
        return n3;
    }
}

