/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.io.input.ThrottledInputStream$1;
import org.apache.commons.io.input.ThrottledInputStream$Builder;

public final class ThrottledInputStream
extends CountingInputStream {
    private final double maxBytesPerSecond;
    private final long startTime = System.currentTimeMillis();
    private Duration totalSleepDuration = Duration.ZERO;

    public static ThrottledInputStream$Builder builder() {
        return new ThrottledInputStream$Builder();
    }

    static long toSleepMillis(long l2, long l3, double d2) {
        if (l2 <= 0L || d2 <= 0.0 || l3 == 0L) {
            return 0L;
        }
        long l4 = (long)((double)l2 / d2 * 1000.0 - (double)l3);
        if (l4 <= 0L) {
            return 0L;
        }
        return l4;
    }

    private ThrottledInputStream(ThrottledInputStream$Builder throttledInputStream$Builder) throws IOException {
        super(throttledInputStream$Builder);
        if (ThrottledInputStream$Builder.access$100(throttledInputStream$Builder) <= 0.0) {
            throw new IllegalArgumentException("Bandwidth " + ThrottledInputStream$Builder.access$100(throttledInputStream$Builder) + " is invalid.");
        }
        this.maxBytesPerSecond = ThrottledInputStream$Builder.access$100(throttledInputStream$Builder);
    }

    @Override
    protected final void beforeRead(int n2) throws IOException {
        this.throttle();
    }

    private long getBytesPerSecond() {
        long l2 = (System.currentTimeMillis() - this.startTime) / 1000L;
        if (l2 == 0L) {
            return this.getByteCount();
        }
        return this.getByteCount() / l2;
    }

    final double getMaxBytesPerSecond() {
        return this.maxBytesPerSecond;
    }

    private long getSleepMillis() {
        return ThrottledInputStream.toSleepMillis(this.getByteCount(), System.currentTimeMillis() - this.startTime, this.maxBytesPerSecond);
    }

    final Duration getTotalSleepDuration() {
        return this.totalSleepDuration;
    }

    private void throttle() throws InterruptedIOException {
        long l2 = this.getSleepMillis();
        if (l2 > 0L) {
            this.totalSleepDuration = this.totalSleepDuration.plus(l2, ChronoUnit.MILLIS);
            try {
                TimeUnit.MILLISECONDS.sleep(l2);
                return;
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException("Thread aborted");
            }
        }
    }

    public final String toString() {
        return "ThrottledInputStream[bytesRead=" + this.getByteCount() + ", maxBytesPerSec=" + this.maxBytesPerSecond + ", bytesPerSec=" + this.getBytesPerSecond() + ", totalSleepDuration=" + this.totalSleepDuration + ']';
    }

    /* synthetic */ ThrottledInputStream(ThrottledInputStream$Builder throttledInputStream$Builder, ThrottledInputStream$1 throttledInputStream$1) throws IOException {
        this(throttledInputStream$Builder);
    }
}

