/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.UnsupportedOperationExceptions;

public class WindowsLineEndingInputStream
extends InputStream {
    private boolean atEos;
    private boolean atSlashCr;
    private boolean atSlashLf;
    private final InputStream in;
    private boolean injectSlashLf;
    private final boolean lineFeedAtEos;

    public WindowsLineEndingInputStream(InputStream inputStream, boolean bl2) {
        this.in = inputStream;
        this.lineFeedAtEos = bl2;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.in.close();
    }

    private int handleEos() {
        if (!this.lineFeedAtEos) {
            return -1;
        }
        if (!this.atSlashLf && !this.atSlashCr) {
            this.atSlashCr = true;
            return 13;
        }
        if (!this.atSlashLf) {
            this.atSlashCr = false;
            this.atSlashLf = true;
            return 10;
        }
        return -1;
    }

    @Override
    public synchronized void mark(int n2) {
        throw UnsupportedOperationExceptions.mark();
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.atEos) {
            return this.handleEos();
        }
        if (this.injectSlashLf) {
            this.injectSlashLf = false;
            return 10;
        }
        boolean bl2 = this.atSlashCr;
        int n2 = this.in.read();
        boolean bl3 = this.atEos = n2 == -1;
        if (!this.atEos) {
            this.atSlashCr = n2 == 13;
            boolean bl4 = this.atSlashLf = n2 == 10;
        }
        if (this.atEos) {
            return this.handleEos();
        }
        if (n2 == 10 && !bl2) {
            this.injectSlashLf = true;
            return 13;
        }
        return n2;
    }
}

