/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.io.input.BOMInputStream$Builder;
import org.apache.commons.io.input.XmlStreamReader$Builder;
import org.apache.commons.io.input.XmlStreamReaderException;

public class XmlStreamReader
extends Reader {
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final String US_ASCII = StandardCharsets.US_ASCII.name();
    private static final String UTF_16BE = StandardCharsets.UTF_16BE.name();
    private static final String UTF_16LE = StandardCharsets.UTF_16LE.name();
    private static final String UTF_32BE = "UTF-32BE";
    private static final String UTF_32LE = "UTF-32LE";
    private static final String UTF_16 = StandardCharsets.UTF_16.name();
    private static final String UTF_32 = "UTF-32";
    private static final String EBCDIC = "CP1047";
    private static final ByteOrderMark[] BOMS = new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE};
    private static final ByteOrderMark[] XML_GUESS_BYTES = new ByteOrderMark[]{new ByteOrderMark(UTF_8, 60, 63, 120, 109), new ByteOrderMark(UTF_16BE, 0, 60, 0, 63), new ByteOrderMark(UTF_16LE, 60, 0, 63, 0), new ByteOrderMark("UTF-32BE", 0, 0, 0, 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 109), new ByteOrderMark("UTF-32LE", 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 109, 0, 0, 0), new ByteOrderMark("CP1047", 76, 111, 167, 148)};
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=[\"']?([.[^; \"']]*)[\"']?");
    public static final Pattern ENCODING_PATTERN = Pattern.compile("^<\\?xml\\s+(?:version\\s*=\\s*(?:(?:\"1\\.[0-9]+\")|(?:'1.[0-9]+'))\\s+)??encoding\\s*=\\s*((?:\"[A-Za-z0-9][A-Za-z0-9._+:-]*\")|(?:'[A-Za-z0-9][A-Za-z0-9._+:-]*'))", 8);
    private static final String RAW_EX_1 = "Illegal encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch";
    private static final String RAW_EX_2 = "Illegal encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] unknown BOM";
    private static final String HTTP_EX_1 = "Illegal encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], BOM must be null";
    private static final String HTTP_EX_2 = "Illegal encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], encoding mismatch";
    private static final String HTTP_EX_3 = "Illegal encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], Illegal MIME";
    private final Reader reader;
    private final String encoding;
    private final String defaultEncoding;

    public static XmlStreamReader$Builder builder() {
        return new XmlStreamReader$Builder();
    }

    static String getContentTypeEncoding(String object) {
        int n2;
        String string = null;
        if (object != null && (n2 = ((String)object).indexOf(";")) >= 0) {
            object = ((String)object).substring(n2 + 1);
            string = ((Matcher)(object = CHARSET_PATTERN.matcher((CharSequence)object))).find() ? ((Matcher)object).group(1) : null;
            string = string != null ? string.toUpperCase(Locale.ROOT) : null;
        }
        return string;
    }

    static String getContentTypeMime(String string) {
        String string2 = null;
        if (string != null) {
            int n2 = string.indexOf(";");
            string2 = n2 >= 0 ? string.substring(0, n2) : string;
            string2 = string2.trim();
        }
        return string2;
    }

    private static String getXmlProlog(InputStream object, String string2) throws IOException {
        String string3 = null;
        if (string2 != null) {
            byte[] byArray = IOUtils.byteArray();
            ((InputStream)object).mark(8192);
            int n2 = 0;
            int n3 = 8192;
            int n4 = ((InputStream)object).read(byArray, 0, 8192);
            int n5 = -1;
            String string4 = "";
            while (n4 != -1 && n5 == -1 && n2 < 8192) {
                n4 = ((InputStream)object).read(byArray, n2 += n4, n3 -= n4);
                string4 = new String(byArray, 0, n2, string2);
                n5 = string4.indexOf(62);
            }
            if (n5 == -1) {
                if (n4 == -1) {
                    throw new IOException("Unexpected end of XML stream");
                }
                throw new IOException("XML prolog or ROOT element not found on first " + n2 + " bytes");
            }
            int n6 = n2;
            if (n6 > 0) {
                ((InputStream)object).reset();
                object = new BufferedReader(new StringReader(string4.substring(0, n5 + 1)));
                StringBuilder stringBuilder = new StringBuilder();
                IOConsumer.forEach(((BufferedReader)object).lines(), string -> stringBuilder.append((String)string).append(' '));
                object = ENCODING_PATTERN.matcher(stringBuilder);
                if (((Matcher)object).find()) {
                    string3 = ((Matcher)object).group(1).toUpperCase(Locale.ROOT);
                    string3 = string3.substring(1, string3.length() - 1);
                }
            }
        }
        return string3;
    }

    static boolean isAppXml(String string) {
        return string != null && (string.equals("application/xml") || string.equals("application/xml-dtd") || string.equals("application/xml-external-parsed-entity") || string.startsWith("application/") && string.endsWith("+xml"));
    }

    static boolean isTextXml(String string) {
        return string != null && (string.equals("text/xml") || string.equals("text/xml-external-parsed-entity") || string.startsWith("text/") && string.endsWith("+xml"));
    }

    @Deprecated
    public XmlStreamReader(File file) throws IOException {
        this(Objects.requireNonNull(file, "file").toPath());
    }

    @Deprecated
    public XmlStreamReader(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    @Deprecated
    public XmlStreamReader(InputStream inputStream, boolean bl2) throws IOException {
        this(inputStream, bl2, null);
    }

    @Deprecated
    public XmlStreamReader(InputStream inputStream, boolean bl2, String object) throws IOException {
        this.defaultEncoding = object;
        inputStream = new BOMInputStream((InputStream)new BufferedInputStream(Objects.requireNonNull(inputStream, "inputStream"), 8192), false, BOMS);
        object = new BOMInputStream(inputStream, true, XML_GUESS_BYTES);
        this.encoding = this.processHttpStream((BOMInputStream)inputStream, (BOMInputStream)object, bl2);
        this.reader = new InputStreamReader((InputStream)object, this.encoding);
    }

    @Deprecated
    public XmlStreamReader(InputStream inputStream, String string) throws IOException {
        this(inputStream, string, true);
    }

    @Deprecated
    public XmlStreamReader(InputStream inputStream, String string, boolean bl2) throws IOException {
        this(inputStream, string, bl2, null);
    }

    @Deprecated
    public XmlStreamReader(InputStream inputStream, String string, boolean bl2, String object) throws IOException {
        this.defaultEncoding = object;
        inputStream = new BOMInputStream((InputStream)new BufferedInputStream(Objects.requireNonNull(inputStream, "inputStream"), 8192), false, BOMS);
        object = new BOMInputStream(inputStream, true, XML_GUESS_BYTES);
        this.encoding = this.processHttpStream((BOMInputStream)inputStream, (BOMInputStream)object, bl2, string);
        this.reader = new InputStreamReader((InputStream)object, this.encoding);
    }

    @Deprecated
    public XmlStreamReader(Path path) throws IOException {
        this(Files.newInputStream(Objects.requireNonNull(path, "file"), new OpenOption[0]));
    }

    public XmlStreamReader(URL uRL) throws IOException {
        this(Objects.requireNonNull(uRL, "url").openConnection(), null);
    }

    public XmlStreamReader(URLConnection uRLConnection, String string) throws IOException {
        Objects.requireNonNull(uRLConnection, "urlConnection");
        this.defaultEncoding = string;
        string = uRLConnection.getContentType();
        InputStream inputStream = uRLConnection.getInputStream();
        inputStream = ((BOMInputStream$Builder)BOMInputStream.builder().setInputStream(new BufferedInputStream(inputStream, 8192))).setInclude(false).setByteOrderMarks(BOMS).get();
        BOMInputStream bOMInputStream = ((BOMInputStream$Builder)BOMInputStream.builder().setInputStream(new BufferedInputStream(inputStream, 8192))).setInclude(true).setByteOrderMarks(XML_GUESS_BYTES).get();
        this.encoding = uRLConnection instanceof HttpURLConnection || string != null ? this.processHttpStream((BOMInputStream)inputStream, bOMInputStream, true, string) : this.processHttpStream((BOMInputStream)inputStream, bOMInputStream, true);
        this.reader = new InputStreamReader((InputStream)bOMInputStream, this.encoding);
    }

    String calculateHttpEncoding(String string, String string2, String string3, boolean bl2, String string4) throws IOException {
        if (bl2 && string3 != null) {
            return string3;
        }
        String string5 = XmlStreamReader.getContentTypeMime(string4);
        string4 = XmlStreamReader.getContentTypeEncoding(string4);
        boolean bl3 = XmlStreamReader.isAppXml(string5);
        boolean bl4 = XmlStreamReader.isTextXml(string5);
        if (!bl3 && !bl4) {
            String string6 = MessageFormat.format(HTTP_EX_3, string5, string4, string, string2, string3);
            throw new XmlStreamReaderException(string6, string5, string4, string, string2, string3);
        }
        if (string4 == null) {
            if (bl3) {
                return this.calculateRawEncoding(string, string2, string3);
            }
            if (this.defaultEncoding == null) {
                return US_ASCII;
            }
            return this.defaultEncoding;
        }
        if (string4.equals(UTF_16BE) || string4.equals(UTF_16LE)) {
            if (string != null) {
                String string7 = MessageFormat.format(HTTP_EX_1, string5, string4, string, string2, string3);
                throw new XmlStreamReaderException(string7, string5, string4, string, string2, string3);
            }
            return string4;
        }
        if (string4.equals(UTF_16)) {
            if (string != null && string.startsWith(UTF_16)) {
                return string;
            }
            String string8 = MessageFormat.format(HTTP_EX_2, string5, string4, string, string2, string3);
            throw new XmlStreamReaderException(string8, string5, string4, string, string2, string3);
        }
        if (string4.equals(UTF_32BE) || string4.equals(UTF_32LE)) {
            if (string != null) {
                String string9 = MessageFormat.format(HTTP_EX_1, string5, string4, string, string2, string3);
                throw new XmlStreamReaderException(string9, string5, string4, string, string2, string3);
            }
            return string4;
        }
        if (string4.equals(UTF_32)) {
            if (string != null && string.startsWith(UTF_32)) {
                return string;
            }
            String string10 = MessageFormat.format(HTTP_EX_2, string5, string4, string, string2, string3);
            throw new XmlStreamReaderException(string10, string5, string4, string, string2, string3);
        }
        return string4;
    }

    String calculateRawEncoding(String string, String string2, String string3) throws IOException {
        if (string == null) {
            if (string2 == null || string3 == null) {
                if (this.defaultEncoding == null) {
                    return UTF_8;
                }
                return this.defaultEncoding;
            }
            if (string3.equals(UTF_16) && (string2.equals(UTF_16BE) || string2.equals(UTF_16LE))) {
                return string2;
            }
            return string3;
        }
        if (string.equals(UTF_8)) {
            if (string2 != null && !string2.equals(UTF_8)) {
                String string4 = MessageFormat.format(RAW_EX_1, string, string2, string3);
                throw new XmlStreamReaderException(string4, string, string2, string3);
            }
            if (string3 != null && !string3.equals(UTF_8)) {
                String string5 = MessageFormat.format(RAW_EX_1, string, string2, string3);
                throw new XmlStreamReaderException(string5, string, string2, string3);
            }
            return string;
        }
        if (string.equals(UTF_16BE) || string.equals(UTF_16LE)) {
            if (string2 != null && !string2.equals(string)) {
                String string6 = MessageFormat.format(RAW_EX_1, string, string2, string3);
                throw new XmlStreamReaderException(string6, string, string2, string3);
            }
            if (string3 != null && !string3.equals(UTF_16) && !string3.equals(string)) {
                String string7 = MessageFormat.format(RAW_EX_1, string, string2, string3);
                throw new XmlStreamReaderException(string7, string, string2, string3);
            }
            return string;
        }
        if (string.equals(UTF_32BE) || string.equals(UTF_32LE)) {
            if (string2 != null && !string2.equals(string)) {
                String string8 = MessageFormat.format(RAW_EX_1, string, string2, string3);
                throw new XmlStreamReaderException(string8, string, string2, string3);
            }
            if (string3 != null && !string3.equals(UTF_32) && !string3.equals(string)) {
                String string9 = MessageFormat.format(RAW_EX_1, string, string2, string3);
                throw new XmlStreamReaderException(string9, string, string2, string3);
            }
            return string;
        }
        String string10 = MessageFormat.format(RAW_EX_2, string, string2, string3);
        throw new XmlStreamReaderException(string10, string, string2, string3);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private String doLenientDetection(String object, XmlStreamReaderException xmlStreamReaderException) throws IOException {
        if (object != null && ((String)object).startsWith("text/html")) {
            object = ((String)object).substring(9);
            object = "text/xml" + (String)object;
            try {
                return this.calculateHttpEncoding(xmlStreamReaderException.getBomEncoding(), xmlStreamReaderException.getXmlGuessEncoding(), xmlStreamReaderException.getXmlEncoding(), true, (String)object);
            }
            catch (XmlStreamReaderException xmlStreamReaderException2) {
                object = xmlStreamReaderException2;
                xmlStreamReaderException = xmlStreamReaderException2;
            }
        }
        if ((object = xmlStreamReaderException.getXmlEncoding()) == null) {
            object = xmlStreamReaderException.getContentTypeEncoding();
        }
        if (object == null) {
            object = this.defaultEncoding == null ? UTF_8 : this.defaultEncoding;
        }
        return object;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private String processHttpStream(BOMInputStream object, BOMInputStream object2, boolean bl2) throws IOException {
        object = ((BOMInputStream)object).getBOMCharsetName();
        String string = ((BOMInputStream)object2).getBOMCharsetName();
        object2 = XmlStreamReader.getXmlProlog((InputStream)object2, string);
        try {
            return this.calculateRawEncoding((String)object, string, (String)object2);
        }
        catch (XmlStreamReaderException xmlStreamReaderException) {
            if (bl2) {
                return this.doLenientDetection(null, xmlStreamReaderException);
            }
            throw xmlStreamReaderException;
        }
    }

    private String processHttpStream(BOMInputStream object, BOMInputStream object2, boolean bl2, String string) throws IOException {
        object = ((BOMInputStream)object).getBOMCharsetName();
        String string2 = ((BOMInputStream)object2).getBOMCharsetName();
        object2 = XmlStreamReader.getXmlProlog((InputStream)object2, string2);
        try {
            return this.calculateHttpEncoding((String)object, string2, (String)object2, bl2, string);
        }
        catch (XmlStreamReaderException xmlStreamReaderException) {
            if (bl2) {
                return this.doLenientDetection(string, xmlStreamReaderException);
            }
            throw xmlStreamReaderException;
        }
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        return this.reader.read(cArray, n2, n3);
    }
}

