/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.file.attribute.FileTimes;

final class SerializableFileTime
implements Serializable {
    static final SerializableFileTime EPOCH = new SerializableFileTime(FileTimes.EPOCH);
    private static final long serialVersionUID = 1L;
    private FileTime fileTime;

    SerializableFileTime(FileTime fileTime) {
        this.fileTime = Objects.requireNonNull(fileTime);
    }

    public final int compareTo(FileTime fileTime) {
        return this.fileTime.compareTo(fileTime);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SerializableFileTime)) {
            return false;
        }
        object = (SerializableFileTime)object;
        return Objects.equals(this.fileTime, ((SerializableFileTime)object).fileTime);
    }

    public final int hashCode() {
        return this.fileTime.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.fileTime = FileTime.from((Instant)objectInputStream.readObject());
    }

    final long to(TimeUnit timeUnit) {
        return this.fileTime.to(timeUnit);
    }

    final Instant toInstant() {
        return this.fileTime.toInstant();
    }

    final long toMillis() {
        return this.fileTime.toMillis();
    }

    public final String toString() {
        return this.fileTime.toString();
    }

    final FileTime unwrap() {
        return this.fileTime;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.fileTime.toInstant());
    }
}

