/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.io.function.Erase;

public class BrokenOutputStream
extends OutputStream {
    public static final BrokenOutputStream INSTANCE = new BrokenOutputStream();
    private final Function<String, Throwable> exceptionFunction;

    public BrokenOutputStream() {
        this((String string) -> new IOException("Broken output stream: " + string));
    }

    public BrokenOutputStream(Function<String, Throwable> function) {
        this.exceptionFunction = function;
    }

    @Deprecated
    public BrokenOutputStream(IOException iOException) {
        this((String string) -> iOException);
    }

    @Deprecated
    public BrokenOutputStream(Supplier<Throwable> supplier) {
        this.exceptionFunction = string -> (Throwable)supplier.get();
    }

    public BrokenOutputStream(Throwable throwable) {
        this((String string) -> throwable);
    }

    @Override
    public void close() throws IOException {
        throw this.rethrow("close()");
    }

    @Override
    public void flush() throws IOException {
        throw this.rethrow("flush()");
    }

    private RuntimeException rethrow(String string) {
        return Erase.rethrow(this.exceptionFunction.apply(string));
    }

    @Override
    public void write(int n2) throws IOException {
        throw this.rethrow("write(int)");
    }
}

