/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ChunkedOutputStream$1;
import org.apache.commons.io.output.ChunkedOutputStream$Builder;

public class ChunkedOutputStream
extends FilterOutputStream {
    private final int chunkSize;

    public static ChunkedOutputStream$Builder builder() {
        return new ChunkedOutputStream$Builder();
    }

    private ChunkedOutputStream(ChunkedOutputStream$Builder chunkedOutputStream$Builder) throws IOException {
        super(chunkedOutputStream$Builder.getOutputStream());
        int n2 = chunkedOutputStream$Builder.getBufferSize();
        if (n2 <= 0) {
            throw new IllegalArgumentException("chunkSize <= 0");
        }
        this.chunkSize = n2;
    }

    @Deprecated
    public ChunkedOutputStream(OutputStream outputStream) {
        this(outputStream, 8192);
    }

    @Deprecated
    public ChunkedOutputStream(OutputStream outputStream, int n2) {
        super(outputStream);
        if (n2 <= 0) {
            throw new IllegalArgumentException("chunkSize <= 0");
        }
        this.chunkSize = n2;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            int n4 = Math.min(n3, this.chunkSize);
            this.out.write(byArray, n2, n4);
            n3 -= n4;
            n2 += n4;
        }
    }

    /* synthetic */ ChunkedOutputStream(ChunkedOutputStream$Builder chunkedOutputStream$Builder, ChunkedOutputStream$1 chunkedOutputStream$1) throws IOException {
        this(chunkedOutputStream$Builder);
    }
}

