/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.OutputStream;
import org.apache.commons.io.output.ProxyOutputStream;

public class CountingOutputStream
extends ProxyOutputStream {
    private long count;

    public CountingOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    protected synchronized void beforeWrite(int n2) {
        this.count += (long)n2;
    }

    public synchronized long getByteCount() {
        return this.count;
    }

    public int getCount() {
        long l2 = this.getByteCount();
        if (l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + l2 + " is too large to be converted to an int");
        }
        return (int)l2;
    }

    public synchronized long resetByteCount() {
        long l2 = this.count;
        this.count = 0L;
        return l2;
    }

    public int resetCount() {
        long l2 = this.resetByteCount();
        if (l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + l2 + " is too large to be converted to an int");
        }
        return (int)l2;
    }
}

