/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Objects;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.FileWriterWithEncoding$1;
import org.apache.commons.io.output.FileWriterWithEncoding$Builder;
import org.apache.commons.io.output.ProxyWriter;

public class FileWriterWithEncoding
extends ProxyWriter {
    public static FileWriterWithEncoding$Builder builder() {
        return new FileWriterWithEncoding$Builder();
    }

    private static OutputStreamWriter initWriter(File file, Object object, boolean bl2) throws IOException {
        Objects.requireNonNull(file, "file");
        OutputStream outputStream = null;
        boolean bl3 = file.exists();
        try {
            outputStream = FileUtils.newOutputStream(file, bl2);
            if (object == null || object instanceof Charset) {
                return new OutputStreamWriter(outputStream, Charsets.toCharset((Charset)object));
            }
            if (object instanceof CharsetEncoder) {
                return new OutputStreamWriter(outputStream, (CharsetEncoder)object);
            }
            return new OutputStreamWriter(outputStream, (String)object);
        }
        catch (IOException | RuntimeException exception) {
            try {
                IOUtils.close((Closeable)outputStream);
            }
            catch (IOException iOException) {
                exception.addSuppressed(iOException);
            }
            if (!bl3) {
                FileUtils.deleteQuietly(file);
            }
            throw exception;
        }
    }

    private FileWriterWithEncoding(FileWriterWithEncoding$Builder fileWriterWithEncoding$Builder) throws IOException {
        super(FileWriterWithEncoding.initWriter(FileWriterWithEncoding$Builder.access$100(fileWriterWithEncoding$Builder), FileWriterWithEncoding$Builder.access$200(fileWriterWithEncoding$Builder), FileWriterWithEncoding$Builder.access$300(fileWriterWithEncoding$Builder)));
    }

    @Deprecated
    public FileWriterWithEncoding(File file, Charset charset) throws IOException {
        this(file, charset, false);
    }

    @Deprecated
    public FileWriterWithEncoding(File file, Charset charset, boolean bl2) throws IOException {
        this(FileWriterWithEncoding.initWriter(file, charset, bl2));
    }

    @Deprecated
    public FileWriterWithEncoding(File file, CharsetEncoder charsetEncoder) throws IOException {
        this(file, charsetEncoder, false);
    }

    @Deprecated
    public FileWriterWithEncoding(File file, CharsetEncoder charsetEncoder, boolean bl2) throws IOException {
        this(FileWriterWithEncoding.initWriter(file, charsetEncoder, bl2));
    }

    @Deprecated
    public FileWriterWithEncoding(File file, String string) throws IOException {
        this(file, string, false);
    }

    @Deprecated
    public FileWriterWithEncoding(File file, String string, boolean bl2) throws IOException {
        this(FileWriterWithEncoding.initWriter(file, string, bl2));
    }

    private FileWriterWithEncoding(OutputStreamWriter outputStreamWriter) {
        super(outputStreamWriter);
    }

    @Deprecated
    public FileWriterWithEncoding(String string, Charset charset) throws IOException {
        this(new File(string), charset, false);
    }

    @Deprecated
    public FileWriterWithEncoding(String string, Charset charset, boolean bl2) throws IOException {
        this(new File(string), charset, bl2);
    }

    @Deprecated
    public FileWriterWithEncoding(String string, CharsetEncoder charsetEncoder) throws IOException {
        this(new File(string), charsetEncoder, false);
    }

    @Deprecated
    public FileWriterWithEncoding(String string, CharsetEncoder charsetEncoder, boolean bl2) throws IOException {
        this(new File(string), charsetEncoder, bl2);
    }

    @Deprecated
    public FileWriterWithEncoding(String string, String string2) throws IOException {
        this(new File(string), string2, false);
    }

    @Deprecated
    public FileWriterWithEncoding(String string, String string2, boolean bl2) throws IOException {
        this(new File(string), string2, bl2);
    }

    /* synthetic */ FileWriterWithEncoding(FileWriterWithEncoding$Builder fileWriterWithEncoding$Builder, FileWriterWithEncoding$1 fileWriterWithEncoding$1) throws IOException {
        this(fileWriterWithEncoding$Builder);
    }
}

