/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.LockableFileWriter$1;
import org.apache.commons.io.output.LockableFileWriter$Builder;

public class LockableFileWriter
extends Writer {
    private static final String LCK = ".lck";
    private final Writer out;
    private final File lockFile;

    public static LockableFileWriter$Builder builder() {
        return new LockableFileWriter$Builder();
    }

    private LockableFileWriter(LockableFileWriter$Builder lockableFileWriter$Builder) throws IOException {
        this(LockableFileWriter$Builder.access$100(lockableFileWriter$Builder), lockableFileWriter$Builder.getCharset(), LockableFileWriter$Builder.access$200(lockableFileWriter$Builder), LockableFileWriter$Builder.access$300(lockableFileWriter$Builder).getFile().toString());
    }

    @Deprecated
    public LockableFileWriter(File file) throws IOException {
        this(file, false, null);
    }

    @Deprecated
    public LockableFileWriter(File file, boolean bl2) throws IOException {
        this(file, bl2, null);
    }

    @Deprecated
    public LockableFileWriter(File file, boolean bl2, String string) throws IOException {
        this(file, Charset.defaultCharset(), bl2, string);
    }

    @Deprecated
    public LockableFileWriter(File file, Charset charset) throws IOException {
        this(file, charset, false, null);
    }

    @Deprecated
    public LockableFileWriter(File file, Charset charset, boolean bl2, String object) throws IOException {
        file = Objects.requireNonNull(file, "file").getAbsoluteFile();
        if (file.getParentFile() != null) {
            FileUtils.forceMkdir(file.getParentFile());
        }
        if (file.isDirectory()) {
            throw new IOException("File specified is a directory");
        }
        object = new File((String)(object != null ? object : FileUtils.getTempDirectoryPath()));
        FileUtils.forceMkdir((File)object);
        this.testLockDir((File)object);
        this.lockFile = new File((File)object, file.getName() + LCK);
        this.createLock();
        this.out = this.initWriter(file, charset, bl2);
    }

    @Deprecated
    public LockableFileWriter(File file, String string) throws IOException {
        this(file, string, false, null);
    }

    @Deprecated
    public LockableFileWriter(File file, String string, boolean bl2, String string2) throws IOException {
        this(file, Charsets.toCharset(string), bl2, string2);
    }

    @Deprecated
    public LockableFileWriter(String string) throws IOException {
        this(string, false, null);
    }

    @Deprecated
    public LockableFileWriter(String string, boolean bl2) throws IOException {
        this(string, bl2, null);
    }

    @Deprecated
    public LockableFileWriter(String string, boolean bl2, String string2) throws IOException {
        this(new File(string), bl2, string2);
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.close();
            return;
        }
        finally {
            FileUtils.delete(this.lockFile);
        }
    }

    private void createLock() throws IOException {
        Class<LockableFileWriter> clazz = LockableFileWriter.class;
        synchronized (LockableFileWriter.class) {
            if (!this.lockFile.createNewFile()) {
                throw new IOException("Can't write file, lock " + this.lockFile.getAbsolutePath() + " exists");
            }
            this.lockFile.deleteOnExit();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    private Writer initWriter(File file, Charset charset, boolean bl2) throws IOException {
        boolean bl3 = file.exists();
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath(), bl2), Charsets.toCharset(charset));
        }
        catch (IOException | RuntimeException exception) {
            FileUtils.deleteQuietly(this.lockFile);
            if (!bl3) {
                FileUtils.deleteQuietly(file);
            }
            throw exception;
        }
    }

    private void testLockDir(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("Could not find lockDir: " + file.getAbsolutePath());
        }
        if (!file.canWrite()) {
            throw new IOException("Could not write to lockDir: " + file.getAbsolutePath());
        }
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.out.write(cArray);
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        this.out.write(cArray, n2, n3);
    }

    @Override
    public void write(int n2) throws IOException {
        this.out.write(n2);
    }

    @Override
    public void write(String string) throws IOException {
        this.out.write(string);
    }

    @Override
    public void write(String string, int n2, int n3) throws IOException {
        this.out.write(string, n2, n3);
    }

    /* synthetic */ LockableFileWriter(LockableFileWriter$Builder lockableFileWriter$Builder, LockableFileWriter$1 lockableFileWriter$1) throws IOException {
        this(lockableFileWriter$Builder);
    }
}

