/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ProxyOutputStream$Builder;

public class ProxyOutputStream
extends FilterOutputStream {
    ProxyOutputStream(ProxyOutputStream$Builder proxyOutputStream$Builder) throws IOException {
        super(proxyOutputStream$Builder.getOutputStream());
    }

    public ProxyOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    protected void afterWrite(int n2) throws IOException {
    }

    protected void beforeWrite(int n2) throws IOException {
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.out, this::handleIOException);
    }

    @Override
    public void flush() throws IOException {
        try {
            this.out.flush();
            return;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return;
        }
    }

    protected void handleIOException(IOException iOException) throws IOException {
        throw iOException;
    }

    public ProxyOutputStream setReference(OutputStream outputStream) {
        this.out = outputStream;
        return this;
    }

    OutputStream unwrap() {
        return this.out;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        try {
            int n2 = IOUtils.length(byArray);
            this.beforeWrite(n2);
            this.out.write(byArray);
            this.afterWrite(n2);
            return;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return;
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.beforeWrite(n3);
            this.out.write(byArray, n2, n3);
            this.afterWrite(n3);
            return;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return;
        }
    }

    @Override
    public void write(int n2) throws IOException {
        try {
            this.beforeWrite(1);
            this.out.write(n2);
            this.afterWrite(1);
            return;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return;
        }
    }
}

