/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.function.Uncheck;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.commons.io.output.AbstractByteArrayOutputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream$1;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream$Builder;

public final class UnsynchronizedByteArrayOutputStream
extends AbstractByteArrayOutputStream<UnsynchronizedByteArrayOutputStream> {
    public static UnsynchronizedByteArrayOutputStream$Builder builder() {
        return new UnsynchronizedByteArrayOutputStream$Builder();
    }

    public static InputStream toBufferedInputStream(InputStream inputStream) throws IOException {
        return UnsynchronizedByteArrayOutputStream.toBufferedInputStream(inputStream, 1024);
    }

    public static InputStream toBufferedInputStream(InputStream inputStream, int n2) throws IOException {
        try (UnsynchronizedByteArrayOutputStream unsynchronizedByteArrayOutputStream = ((UnsynchronizedByteArrayOutputStream$Builder)UnsynchronizedByteArrayOutputStream.builder().setBufferSize(n2)).get();){
            ((AbstractByteArrayOutputStream)unsynchronizedByteArrayOutputStream).write(inputStream);
            inputStream = ((AbstractByteArrayOutputStream)unsynchronizedByteArrayOutputStream).toInputStream();
            return inputStream;
        }
    }

    @Deprecated
    public UnsynchronizedByteArrayOutputStream() {
        this(1024);
    }

    private UnsynchronizedByteArrayOutputStream(UnsynchronizedByteArrayOutputStream$Builder unsynchronizedByteArrayOutputStream$Builder) {
        this(unsynchronizedByteArrayOutputStream$Builder.getBufferSize());
    }

    @Deprecated
    public UnsynchronizedByteArrayOutputStream(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n2);
        }
        this.needNewBuffer(n2);
    }

    @Override
    public final void reset() {
        this.resetImpl();
    }

    @Override
    public final int size() {
        return this.count;
    }

    @Override
    public final byte[] toByteArray() {
        return this.toByteArrayImpl();
    }

    @Override
    public final InputStream toInputStream() {
        return this.toInputStream((byArray, n2, n3) -> Uncheck.get(() -> UnsynchronizedByteArrayInputStream.builder().setByteArray(byArray).setOffset(n2).setLength(n3).get()));
    }

    @Override
    public final void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException(String.format("offset=%,d, length=%,d", n2, n3));
        }
        if (n3 == 0) {
            return;
        }
        this.writeImpl(byArray, n2, n3);
    }

    @Override
    public final int write(InputStream inputStream) throws IOException {
        return this.writeImpl(inputStream);
    }

    @Override
    public final void write(int n2) {
        this.writeImpl(n2);
    }

    @Override
    public final void writeTo(OutputStream outputStream) throws IOException {
        this.writeToImpl(outputStream);
    }

    /* synthetic */ UnsynchronizedByteArrayOutputStream(UnsynchronizedByteArrayOutputStream$Builder unsynchronizedByteArrayOutputStream$Builder, UnsynchronizedByteArrayOutputStream$1 unsynchronizedByteArrayOutputStream$1) {
        this(unsynchronizedByteArrayOutputStream$Builder);
    }
}

