/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.input.XmlStreamReader;
import org.apache.commons.io.output.XmlStreamWriter$1;
import org.apache.commons.io.output.XmlStreamWriter$Builder;

public class XmlStreamWriter
extends Writer {
    private static final int BUFFER_SIZE = 8192;
    private final OutputStream out;
    private final Charset defaultCharset;
    private StringWriter prologWriter = new StringWriter(8192);
    private Writer writer;
    private Charset charset;

    public static XmlStreamWriter$Builder builder() {
        return new XmlStreamWriter$Builder();
    }

    private XmlStreamWriter(XmlStreamWriter$Builder xmlStreamWriter$Builder) throws IOException {
        this(xmlStreamWriter$Builder.getOutputStream(), xmlStreamWriter$Builder.getCharset());
    }

    @Deprecated
    public XmlStreamWriter(File file) throws FileNotFoundException {
        this(file, null);
    }

    @Deprecated
    public XmlStreamWriter(File file, String string) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), string);
    }

    @Deprecated
    public XmlStreamWriter(OutputStream outputStream) {
        this(outputStream, StandardCharsets.UTF_8);
    }

    private XmlStreamWriter(OutputStream outputStream, Charset charset) {
        this.out = outputStream;
        this.defaultCharset = Objects.requireNonNull(charset);
    }

    @Deprecated
    public XmlStreamWriter(OutputStream outputStream, String string) {
        this(outputStream, Charsets.toCharset(string, StandardCharsets.UTF_8));
    }

    @Override
    public void close() throws IOException {
        if (this.writer == null) {
            this.charset = this.defaultCharset;
            this.writer = new OutputStreamWriter(this.out, this.charset);
            this.writer.write(this.prologWriter.toString());
        }
        this.writer.close();
    }

    private void detectEncoding(char[] cArray, int n2, int n3) throws IOException {
        int n4 = n3;
        StringBuffer stringBuffer = this.prologWriter.getBuffer();
        if (stringBuffer.length() + n3 > 8192) {
            n4 = 8192 - stringBuffer.length();
        }
        this.prologWriter.write(cArray, n2, n4);
        if (stringBuffer.length() >= 5) {
            if (stringBuffer.substring(0, 5).equals("<?xml")) {
                int n5 = stringBuffer.indexOf("?>");
                if (n5 > 0) {
                    Object object = XmlStreamReader.ENCODING_PATTERN.matcher(stringBuffer.substring(0, n5));
                    if (((Matcher)object).find()) {
                        object = ((Matcher)object).group(1).toUpperCase(Locale.ROOT);
                        this.charset = Charset.forName(((String)object).substring(1, ((String)object).length() - 1));
                    } else {
                        this.charset = this.defaultCharset;
                    }
                } else if (stringBuffer.length() >= 8192) {
                    this.charset = this.defaultCharset;
                }
            } else {
                this.charset = this.defaultCharset;
            }
            if (this.charset != null) {
                this.prologWriter = null;
                this.writer = new OutputStreamWriter(this.out, this.charset);
                this.writer.write(stringBuffer.toString());
                if (n3 > n4) {
                    this.writer.write(cArray, n2 + n4, n3 - n4);
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public String getDefaultEncoding() {
        return this.defaultCharset.name();
    }

    public String getEncoding() {
        return this.charset.name();
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        if (this.prologWriter != null) {
            this.detectEncoding(cArray, n2, n3);
            return;
        }
        this.writer.write(cArray, n2, n3);
    }

    /* synthetic */ XmlStreamWriter(XmlStreamWriter$Builder xmlStreamWriter$Builder, XmlStreamWriter$1 xmlStreamWriter$1) throws IOException {
        this(xmlStreamWriter$Builder);
    }
}

