/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.regex.Pattern;
import org.apache.commons.io.serialization.ClassNameMatcher;
import org.apache.commons.io.serialization.ObjectStreamClassPredicate;
import org.apache.commons.io.serialization.ValidatingObjectInputStream$1;
import org.apache.commons.io.serialization.ValidatingObjectInputStream$Builder;

public class ValidatingObjectInputStream
extends ObjectInputStream {
    private final ObjectStreamClassPredicate predicate;

    public static ValidatingObjectInputStream$Builder builder() {
        return new ValidatingObjectInputStream$Builder();
    }

    private ValidatingObjectInputStream(ValidatingObjectInputStream$Builder validatingObjectInputStream$Builder) throws IOException {
        this(validatingObjectInputStream$Builder.getInputStream(), ValidatingObjectInputStream$Builder.access$100(validatingObjectInputStream$Builder));
    }

    @Deprecated
    public ValidatingObjectInputStream(InputStream inputStream) throws IOException {
        this(inputStream, new ObjectStreamClassPredicate());
    }

    private ValidatingObjectInputStream(InputStream inputStream, ObjectStreamClassPredicate objectStreamClassPredicate) throws IOException {
        super(inputStream);
        this.predicate = objectStreamClassPredicate;
    }

    public ValidatingObjectInputStream accept(Class<?> ... classArray) {
        this.predicate.accept(classArray);
        return this;
    }

    public ValidatingObjectInputStream accept(ClassNameMatcher classNameMatcher) {
        this.predicate.accept(classNameMatcher);
        return this;
    }

    public ValidatingObjectInputStream accept(Pattern pattern) {
        this.predicate.accept(pattern);
        return this;
    }

    public ValidatingObjectInputStream accept(String ... stringArray) {
        this.predicate.accept(stringArray);
        return this;
    }

    private void checkClassName(String string) throws InvalidClassException {
        if (!this.predicate.test(string)) {
            this.invalidClassNameFound(string);
        }
    }

    protected void invalidClassNameFound(String string) throws InvalidClassException {
        throw new InvalidClassException("Class name not accepted: " + string);
    }

    public <T> T readObjectCast() throws ClassNotFoundException, IOException {
        return (T)super.readObject();
    }

    public ValidatingObjectInputStream reject(Class<?> ... classArray) {
        this.predicate.reject(classArray);
        return this;
    }

    public ValidatingObjectInputStream reject(ClassNameMatcher classNameMatcher) {
        this.predicate.reject(classNameMatcher);
        return this;
    }

    public ValidatingObjectInputStream reject(Pattern pattern) {
        this.predicate.reject(pattern);
        return this;
    }

    public ValidatingObjectInputStream reject(String ... stringArray) {
        this.predicate.reject(stringArray);
        return this;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        this.checkClassName(objectStreamClass.getName());
        return super.resolveClass(objectStreamClass);
    }

    /* synthetic */ ValidatingObjectInputStream(ValidatingObjectInputStream$Builder validatingObjectInputStream$Builder, ValidatingObjectInputStream$1 validatingObjectInputStream$1) throws IOException {
        this(validatingObjectInputStream$Builder);
    }
}

