/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import org.apache.commons.lang3.AppendableJoiner$1;
import org.apache.commons.lang3.AppendableJoiner$Builder;
import org.apache.commons.lang3.exception.UncheckedException;
import org.apache.commons.lang3.function.FailableBiConsumer;

public final class AppendableJoiner<T> {
    private final CharSequence prefix;
    private final CharSequence suffix;
    private final CharSequence delimiter;
    private final FailableBiConsumer<Appendable, T, IOException> appender;

    public static <T> AppendableJoiner$Builder<T> builder() {
        return new AppendableJoiner$Builder();
    }

    @SafeVarargs
    static <A extends Appendable, T> A joinA(A a2, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, FailableBiConsumer<Appendable, T, IOException> failableBiConsumer, T ... TArray) throws IOException {
        return AppendableJoiner.joinArray(a2, charSequence, charSequence2, charSequence3, failableBiConsumer, TArray);
    }

    private static <A extends Appendable, T> A joinArray(A a2, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, FailableBiConsumer<Appendable, T, IOException> failableBiConsumer, T[] TArray) throws IOException {
        a2.append(charSequence);
        if (TArray != null) {
            if (TArray.length > 0) {
                failableBiConsumer.accept(a2, (A)TArray[0]);
            }
            for (int i2 = 1; i2 < TArray.length; ++i2) {
                a2.append(charSequence3);
                failableBiConsumer.accept(a2, (A)TArray[i2]);
            }
        }
        a2.append(charSequence2);
        return a2;
    }

    static <T> StringBuilder joinI(StringBuilder stringBuilder, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, FailableBiConsumer<Appendable, T, IOException> failableBiConsumer, Iterable<T> iterable) {
        try {
            return AppendableJoiner.joinIterable(stringBuilder, charSequence, charSequence2, charSequence3, failableBiConsumer, iterable);
        }
        catch (IOException iOException) {
            throw new UncheckedException(iOException);
        }
    }

    private static <A extends Appendable, T> A joinIterable(A a2, CharSequence iterator, CharSequence charSequence, CharSequence charSequence2, FailableBiConsumer<Appendable, T, IOException> failableBiConsumer, Iterable<T> iterable) throws IOException {
        a2.append((CharSequence)((Object)iterator));
        if (iterable != null) {
            iterator = iterable.iterator();
            if (iterator.hasNext()) {
                failableBiConsumer.accept(a2, (A)iterator.next());
            }
            while (iterator.hasNext()) {
                a2.append(charSequence2);
                failableBiConsumer.accept(a2, (A)iterator.next());
            }
        }
        a2.append(charSequence);
        return a2;
    }

    @SafeVarargs
    static <T> StringBuilder joinSB(StringBuilder stringBuilder, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, FailableBiConsumer<Appendable, T, IOException> failableBiConsumer, T ... TArray) {
        try {
            return AppendableJoiner.joinArray(stringBuilder, charSequence, charSequence2, charSequence3, failableBiConsumer, TArray);
        }
        catch (IOException iOException) {
            throw new UncheckedException(iOException);
        }
    }

    private static CharSequence nonNull(CharSequence charSequence) {
        if (charSequence != null) {
            return charSequence;
        }
        return "";
    }

    private AppendableJoiner(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, FailableBiConsumer<Appendable, T, IOException> failableBiConsumer) {
        this.prefix = AppendableJoiner.nonNull(charSequence);
        this.suffix = AppendableJoiner.nonNull(charSequence2);
        this.delimiter = AppendableJoiner.nonNull(charSequence3);
        this.appender = failableBiConsumer != null ? failableBiConsumer : (appendable, object) -> appendable.append(String.valueOf(object));
    }

    public final StringBuilder join(StringBuilder stringBuilder, Iterable<T> iterable) {
        return AppendableJoiner.joinI(stringBuilder, this.prefix, this.suffix, this.delimiter, this.appender, iterable);
    }

    public final StringBuilder join(StringBuilder stringBuilder, T ... TArray) {
        return AppendableJoiner.joinSB(stringBuilder, this.prefix, this.suffix, this.delimiter, this.appender, TArray);
    }

    public final <A extends Appendable> A joinA(A a2, Iterable<T> iterable) throws IOException {
        return AppendableJoiner.joinIterable(a2, this.prefix, this.suffix, this.delimiter, this.appender, iterable);
    }

    public final <A extends Appendable> A joinA(A a2, T ... TArray) throws IOException {
        return AppendableJoiner.joinA(a2, this.prefix, this.suffix, this.delimiter, this.appender, TArray);
    }

    /* synthetic */ AppendableJoiner(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, FailableBiConsumer failableBiConsumer, AppendableJoiner$1 appendableJoiner$1) {
        this(charSequence, charSequence2, charSequence3, failableBiConsumer);
    }
}

