/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Objects;
import java.util.Random;

final class CachedRandomBits {
    private static final int MAX_CACHE_SIZE = 0xFFFFFFF;
    private static final int MAX_BITS = 32;
    private static final int BIT_INDEX_MASK = 7;
    private static final int BITS_PER_BYTE = 8;
    private final Random random;
    private final byte[] cache;
    private int bitIndex;

    CachedRandomBits(int n2, Random random) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("cacheSize must be positive");
        }
        this.cache = n2 <= 0xFFFFFFF ? new byte[n2] : new byte[0xFFFFFFF];
        this.random = Objects.requireNonNull(random, "random");
        this.random.nextBytes(this.cache);
        this.bitIndex = 0;
    }

    public final int nextBits(int n2) {
        if (n2 > 32 || n2 <= 0) {
            throw new IllegalArgumentException("number of bits must be between 1 and 32");
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (this.bitIndex >> 3 >= this.cache.length) {
                assert (this.bitIndex == this.cache.length << 3);
                this.random.nextBytes(this.cache);
                this.bitIndex = 0;
            }
            int n5 = Math.min(8 - (this.bitIndex & 7), n2 - n4);
            n3 <<= n5;
            n3 |= this.cache[this.bitIndex >> 3] >> (this.bitIndex & 7) & (1 << n5) - 1;
            n4 += n5;
            this.bitIndex += n5;
        }
        return n3;
    }
}

