/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.lang3.CharRange$CharacterIterator;

final class CharRange
implements Serializable,
Iterable<Character> {
    private static final long serialVersionUID = 8270183163158333422L;
    static final CharRange[] EMPTY_ARRAY = new CharRange[0];
    private final char start;
    private final char end;
    private final boolean negated;
    private transient String iToString;

    public static CharRange is(char c2) {
        char c3 = c2;
        return new CharRange(c3, c3, false);
    }

    public static CharRange isIn(char c2, char c3) {
        return new CharRange(c2, c3, false);
    }

    public static CharRange isNot(char c2) {
        char c3 = c2;
        return new CharRange(c3, c3, true);
    }

    public static CharRange isNotIn(char c2, char c3) {
        return new CharRange(c2, c3, true);
    }

    private CharRange(char c2, char c3, boolean bl2) {
        if (c2 > c3) {
            char c4 = c2;
            c2 = c3;
            c3 = c4;
        }
        this.start = c2;
        this.end = c3;
        this.negated = bl2;
    }

    public final boolean contains(char c2) {
        return (c2 >= this.start && c2 <= this.end) != this.negated;
    }

    public final boolean contains(CharRange charRange) {
        Objects.requireNonNull(charRange, "range");
        if (this.negated) {
            if (charRange.negated) {
                return this.start >= charRange.start && this.end <= charRange.end;
            }
            return charRange.end < this.start || charRange.start > this.end;
        }
        if (charRange.negated) {
            return this.start == '\u0000' && this.end == '\uffff';
        }
        return this.start <= charRange.start && this.end >= charRange.end;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CharRange)) {
            return false;
        }
        object = (CharRange)object;
        return this.start == ((CharRange)object).start && this.end == ((CharRange)object).end && this.negated == ((CharRange)object).negated;
    }

    public final char getEnd() {
        return this.end;
    }

    public final char getStart() {
        return this.start;
    }

    public final int hashCode() {
        return 83 + this.start + 7 * this.end + (this.negated ? 1 : 0);
    }

    public final boolean isNegated() {
        return this.negated;
    }

    @Override
    public final Iterator<Character> iterator() {
        return new CharRange$CharacterIterator(this, null);
    }

    public final String toString() {
        if (this.iToString == null) {
            StringBuilder stringBuilder = new StringBuilder(4);
            if (this.isNegated()) {
                stringBuilder.append('^');
            }
            stringBuilder.append(this.start);
            if (this.start != this.end) {
                stringBuilder.append('-');
                stringBuilder.append(this.end);
            }
            this.iToString = stringBuilder.toString();
        }
        return this.iToString;
    }

    static /* synthetic */ boolean access$000(CharRange charRange) {
        return charRange.negated;
    }

    static /* synthetic */ char access$100(CharRange charRange) {
        return charRange.start;
    }

    static /* synthetic */ char access$200(CharRange charRange) {
        return charRange.end;
    }
}

