/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils$1;
import org.apache.commons.lang3.ClassUtils$2;
import org.apache.commons.lang3.ClassUtils$Interfaces;
import org.apache.commons.lang3.StringUtils;

public class ClassUtils {
    private static final int MAX_DIMENSIONS = 255;
    private static final Comparator<Class<?>> COMPARATOR = (clazz, clazz2) -> Objects.compare(ClassUtils.getName(clazz), ClassUtils.getName(clazz2), String::compareTo);
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String PACKAGE_SEPARATOR = ".";
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    public static final String INNER_CLASS_SEPARATOR = "$";
    private static final Map<String, Class<?>> NAME_PRIMITIVE_MAP = new HashMap();
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP;
    private static final Map<Class<?>, Class<?>> WRAPPER_PRIMITIVE_MAP;
    private static final Map<String, String> ABBREVIATION_MAP;
    private static final Map<String, String> REVERSE_ABBREVIATION_MAP;

    public static Comparator<Class<?>> comparator() {
        return COMPARATOR;
    }

    public static List<String> convertClassesToClassNames(List<Class<?>> list) {
        if (list == null) {
            return null;
        }
        return list.stream().map(clazz -> ClassUtils.getName(clazz, null)).collect(Collectors.toList());
    }

    public static List<Class<?>> convertClassNamesToClasses(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(list.size());
        list.forEach(string -> {
            try {
                arrayList.add(Class.forName(string));
                return;
            }
            catch (Exception exception) {
                arrayList.add(null);
                return;
            }
        });
        return arrayList;
    }

    public static String getAbbreviatedName(Class<?> clazz, int n2) {
        if (clazz == null) {
            return "";
        }
        return ClassUtils.getAbbreviatedName(clazz.getName(), n2);
    }

    public static String getAbbreviatedName(String object, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("len must be > 0");
        }
        if (object == null) {
            return "";
        }
        if (((String)object).length() <= n2) {
            return object;
        }
        object = ((String)object).toCharArray();
        int n3 = 0;
        int n4 = 0;
        while (n4 < ((Object)object).length) {
            int n5 = n3;
            while (n4 < ((Object)object).length && object[n4] != 46) {
                object[n5++] = object[n4++];
            }
            if (ClassUtils.useFull(n5, n4, ((Object)object).length, n2) || ++n3 > n5) {
                n3 = n5;
            }
            if (n4 >= ((Object)object).length) continue;
            object[n3++] = object[n4++];
        }
        return new String((char[])object, 0, n3);
    }

    public static List<Class<?>> getAllInterfaces(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        ClassUtils.getAllInterfaces(clazz, linkedHashSet);
        return new ArrayList(linkedHashSet);
    }

    private static void getAllInterfaces(Class<?> clazz, HashSet<Class<?>> hashSet) {
        while (clazz != null) {
            Class<?>[] classArray = clazz.getInterfaces();
            Class<?>[] classArray2 = classArray;
            classArray2 = classArray;
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Class<?> clazz2 = classArray2[i2];
                if (!hashSet.add(clazz2)) continue;
                ClassUtils.getAllInterfaces(clazz2, hashSet);
            }
            clazz = clazz.getSuperclass();
        }
    }

    public static List<Class<?>> getAllSuperclasses(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (clazz = clazz.getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
            arrayList.add(clazz);
        }
        return arrayList;
    }

    public static String getCanonicalName(Class<?> clazz) {
        return ClassUtils.getCanonicalName(clazz, "");
    }

    public static String getCanonicalName(Class<?> object, String string) {
        if (object == null) {
            return string;
        }
        if ((object = ((Class)object).getCanonicalName()) == null) {
            return string;
        }
        return object;
    }

    public static String getCanonicalName(Object object) {
        return ClassUtils.getCanonicalName(object, "");
    }

    public static String getCanonicalName(Object object, String string) {
        if (object == null) {
            return string;
        }
        if ((object = object.getClass().getCanonicalName()) == null) {
            return string;
        }
        return object;
    }

    private static String getCanonicalName(String string) {
        String string2 = StringUtils.deleteWhitespace(string);
        if (string2 == null) {
            return null;
        }
        int n2 = 0;
        int n3 = string2.length();
        while (n2 < n3 && string2.charAt(n2) == '[') {
            if (++n2 <= 255) continue;
            throw new IllegalArgumentException(String.format("Maximum array dimension %d exceeded", 255));
        }
        if (n2 >= n3) {
            throw new IllegalArgumentException(String.format("Invalid class name %s", string));
        }
        if (n2 <= 0) {
            return string2;
        }
        if ((string2 = string2.substring(n2)).startsWith("L")) {
            if (!string2.endsWith(";") || string2.length() < 3) {
                throw new IllegalArgumentException(String.format("Invalid class name %s", string));
            }
            string2 = string2.substring(1, string2.length() - 1);
        } else if (string2.length() == 1) {
            String string3 = REVERSE_ABBREVIATION_MAP.get(string2.substring(0, 1));
            if (string3 == null) {
                throw new IllegalArgumentException(String.format("Invalid class name %s", string));
            }
            string2 = string3;
        } else {
            throw new IllegalArgumentException(String.format("Invalid class name %s", string));
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length() + (n2 << 1));
        stringBuilder.append(string2);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append("[]");
        }
        return stringBuilder.toString();
    }

    public static Class<?> getClass(ClassLoader classLoader, String string) throws ClassNotFoundException {
        return ClassUtils.getClass(classLoader, string, true);
    }

    public static Class<?> getClass(ClassLoader classLoader, String string, boolean bl2) throws ClassNotFoundException {
        while (true) {
            try {
                Class<?> clazz = ClassUtils.getPrimitiveClass(string);
                if (clazz != null) {
                    return clazz;
                }
                return Class.forName(ClassUtils.toCanonicalName(string), bl2, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                int n2 = string.lastIndexOf(46);
                if (n2 == -1) continue;
                string = string.substring(0, n2) + '$' + string.substring(n2 + 1);
                if (n2 != -1) continue;
                throw new ClassNotFoundException(string);
            }
            break;
        }
    }

    public static Class<?> getClass(String string) throws ClassNotFoundException {
        return ClassUtils.getClass(string, true);
    }

    public static Class<?> getClass(String string, boolean bl2) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        classLoader = classLoader == null ? ClassUtils.class.getClassLoader() : classLoader;
        return ClassUtils.getClass(classLoader, string, bl2);
    }

    public static <T> Class<T> getComponentType(Class<T[]> clazz) {
        if (clazz == null) {
            return null;
        }
        return clazz.getComponentType();
    }

    public static String getName(Class<?> clazz) {
        return ClassUtils.getName(clazz, "");
    }

    public static String getName(Class<?> clazz, String string) {
        return ClassUtils.getName(clazz, string, false);
    }

    static String getName(Class<?> clazz, String string, boolean bl2) {
        if (clazz == null) {
            return string;
        }
        if (bl2) {
            return clazz.getSimpleName();
        }
        return clazz.getName();
    }

    public static String getName(Object object) {
        return ClassUtils.getName(object, "");
    }

    public static String getName(Object object, String string) {
        if (object == null) {
            return string;
        }
        return object.getClass().getName();
    }

    public static String getPackageCanonicalName(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        return ClassUtils.getPackageCanonicalName(clazz.getName());
    }

    public static String getPackageCanonicalName(Object object, String string) {
        if (object == null) {
            return string;
        }
        return ClassUtils.getPackageCanonicalName(object.getClass().getName());
    }

    public static String getPackageCanonicalName(String string) {
        return ClassUtils.getPackageName(ClassUtils.getCanonicalName(string));
    }

    public static String getPackageName(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        return ClassUtils.getPackageName(clazz.getName());
    }

    public static String getPackageName(Object object, String string) {
        if (object == null) {
            return string;
        }
        return ClassUtils.getPackageName(object.getClass());
    }

    public static String getPackageName(String string) {
        if (StringUtils.isEmpty(string)) {
            return "";
        }
        int n2 = 0;
        while (string.charAt(n2) == '[') {
            ++n2;
        }
        if ((string = string.substring(n2)).charAt(0) == 'L') {
            String string2 = string;
            if (string2.charAt(string2.length() - 1) == ';') {
                string = string.substring(1);
            }
        }
        if ((n2 = string.lastIndexOf(46)) == -1) {
            return "";
        }
        return string.substring(0, n2);
    }

    static Class<?> getPrimitiveClass(String string) {
        return NAME_PRIMITIVE_MAP.get(string);
    }

    public static Method getPublicMethod(Class<?> object, String string, Class<?> ... classArray) throws NoSuchMethodException {
        Object object2 = ((Class)object).getMethod(string, classArray);
        if (ClassUtils.isPublic(((Method)object2).getDeclaringClass())) {
            return object2;
        }
        object2 = new ArrayList(ClassUtils.getAllInterfaces(object));
        object2.addAll(ClassUtils.getAllSuperclasses(object));
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (Class)object.next();
            if (!ClassUtils.isPublic(object2)) continue;
            try {
                object2 = ((Class)object2).getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            if (!Modifier.isPublic(((Method)object2).getDeclaringClass().getModifiers())) continue;
            return object2;
        }
        throw new NoSuchMethodException("Can't find a public method for " + string + " " + ArrayUtils.toString(classArray));
    }

    public static String getShortCanonicalName(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        return ClassUtils.getShortCanonicalName(clazz.getCanonicalName());
    }

    public static String getShortCanonicalName(Object object, String string) {
        if (object == null) {
            return string;
        }
        return ClassUtils.getShortCanonicalName(object.getClass());
    }

    public static String getShortCanonicalName(String string) {
        return ClassUtils.getShortClassName(ClassUtils.getCanonicalName(string));
    }

    public static String getShortClassName(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        return ClassUtils.getShortClassName(clazz.getName());
    }

    public static String getShortClassName(Object object, String string) {
        if (object == null) {
            return string;
        }
        return ClassUtils.getShortClassName(object.getClass());
    }

    public static String getShortClassName(String string) {
        int n2;
        if (StringUtils.isEmpty(string)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string.startsWith("[")) {
            while (string.charAt(0) == '[') {
                string = string.substring(1);
                stringBuilder.append("[]");
            }
            if (string.charAt(0) == 'L') {
                String string2 = string;
                if (string2.charAt(string2.length() - 1) == ';') {
                    string = string.substring(1, string.length() - 1);
                }
            }
            if (REVERSE_ABBREVIATION_MAP.containsKey(string)) {
                string = REVERSE_ABBREVIATION_MAP.get(string);
            }
        }
        int n3 = string.indexOf(36, (n2 = string.lastIndexOf(46)) == -1 ? 0 : n2 + 1);
        string = string.substring(n2 + 1);
        if (n3 != -1) {
            string = string.replace('$', '.');
        }
        return string + stringBuilder;
    }

    public static String getSimpleName(Class<?> clazz) {
        return ClassUtils.getSimpleName(clazz, "");
    }

    public static String getSimpleName(Class<?> clazz, String string) {
        if (clazz == null) {
            return string;
        }
        return clazz.getSimpleName();
    }

    public static String getSimpleName(Object object) {
        return ClassUtils.getSimpleName(object, "");
    }

    public static String getSimpleName(Object object, String string) {
        if (object == null) {
            return string;
        }
        return object.getClass().getSimpleName();
    }

    public static Iterable<Class<?>> hierarchy(Class<?> clazz) {
        return ClassUtils.hierarchy(clazz, ClassUtils$Interfaces.EXCLUDE);
    }

    public static Iterable<Class<?>> hierarchy(Class<?> object, ClassUtils$Interfaces classUtils$Interfaces) {
        object = () -> {
            object = new AtomicReference<Class>((Class)object);
            return new ClassUtils$1((AtomicReference)object);
        };
        if (classUtils$Interfaces != ClassUtils$Interfaces.INCLUDE) {
            return object;
        }
        return () -> ClassUtils.lambda$hierarchy$5((Iterable)object);
    }

    public static boolean isAssignable(Class<?> clazz, Class<?> clazz2) {
        return ClassUtils.isAssignable(clazz, clazz2, true);
    }

    public static boolean isAssignable(Class<?> clazz, Class<?> clazz2, boolean bl2) {
        if (clazz2 == null) {
            return false;
        }
        if (clazz == null) {
            return !clazz2.isPrimitive();
        }
        if (bl2) {
            if (clazz.isPrimitive() && !clazz2.isPrimitive() && (clazz = ClassUtils.primitiveToWrapper(clazz)) == null) {
                return false;
            }
            if (clazz2.isPrimitive() && !clazz.isPrimitive() && (clazz = ClassUtils.wrapperToPrimitive(clazz)) == null) {
                return false;
            }
        }
        if (clazz.equals(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            if (!clazz2.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(clazz)) {
                return Long.TYPE.equals(clazz2) || Float.TYPE.equals(clazz2) || Double.TYPE.equals(clazz2);
            }
            if (Long.TYPE.equals(clazz)) {
                return Float.TYPE.equals(clazz2) || Double.TYPE.equals(clazz2);
            }
            if (Boolean.TYPE.equals(clazz)) {
                return false;
            }
            if (Double.TYPE.equals(clazz)) {
                return false;
            }
            if (Float.TYPE.equals(clazz)) {
                return Double.TYPE.equals(clazz2);
            }
            if (Character.TYPE.equals(clazz) || Short.TYPE.equals(clazz)) {
                return Integer.TYPE.equals(clazz2) || Long.TYPE.equals(clazz2) || Float.TYPE.equals(clazz2) || Double.TYPE.equals(clazz2);
            }
            if (Byte.TYPE.equals(clazz)) {
                return Short.TYPE.equals(clazz2) || Integer.TYPE.equals(clazz2) || Long.TYPE.equals(clazz2) || Float.TYPE.equals(clazz2) || Double.TYPE.equals(clazz2);
            }
            return false;
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public static boolean isAssignable(Class<?>[] classArray, Class<?> ... classArray2) {
        return ClassUtils.isAssignable(classArray, classArray2, true);
    }

    public static boolean isAssignable(Class<?>[] classArray, Class<?>[] classArray2, boolean bl2) {
        if (!ArrayUtils.isSameLength(classArray, classArray2)) {
            return false;
        }
        classArray = ArrayUtils.nullToEmpty(classArray);
        classArray2 = ArrayUtils.nullToEmpty(classArray2);
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (ClassUtils.isAssignable(classArray[i2], classArray2[i2], bl2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInnerClass(Class<?> clazz) {
        return clazz != null && clazz.getEnclosingClass() != null;
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        return clazz != null && clazz.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz);
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        return WRAPPER_PRIMITIVE_MAP.containsKey(clazz);
    }

    public static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static Class<?>[] primitivesToWrappers(Class<?> ... classArray) {
        if (classArray == null) {
            return null;
        }
        if (classArray.length == 0) {
            return classArray;
        }
        return ArrayUtils.setAll(new Class[classArray.length], n2 -> ClassUtils.primitiveToWrapper(classArray[n2]));
    }

    public static Class<?> primitiveToWrapper(Class<?> clazz) {
        if (clazz != null && clazz.isPrimitive()) {
            return PRIMITIVE_WRAPPER_MAP.get(clazz);
        }
        return clazz;
    }

    private static String toCanonicalName(String string) {
        string = StringUtils.deleteWhitespace(string);
        Objects.requireNonNull(string, "className");
        if (string.endsWith("[]")) {
            StringBuilder stringBuilder = new StringBuilder();
            while (string.endsWith("[]")) {
                string = string.substring(0, string.length() - 2);
                stringBuilder.append("[");
            }
            String string2 = ABBREVIATION_MAP.get(string);
            if (string2 != null) {
                stringBuilder.append(string2);
            } else {
                stringBuilder.append("L").append(string).append(";");
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public static Class<?>[] toClass(Object ... objectArray) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        return ArrayUtils.setAll(new Class[objectArray.length], n2 -> {
            if (objectArray[n2] == null) {
                return null;
            }
            return objectArray[n2].getClass();
        });
    }

    private static boolean useFull(int n2, int n3, int n4, int n5) {
        return n3 >= n4 || n2 + n4 - n3 <= n5;
    }

    public static Class<?>[] wrappersToPrimitives(Class<?> ... classArray) {
        if (classArray == null) {
            return null;
        }
        if (classArray.length == 0) {
            return classArray;
        }
        return ArrayUtils.setAll(new Class[classArray.length], n2 -> ClassUtils.wrapperToPrimitive(classArray[n2]));
    }

    public static Class<?> wrapperToPrimitive(Class<?> clazz) {
        return WRAPPER_PRIMITIVE_MAP.get(clazz);
    }

    @Deprecated
    public ClassUtils() {
    }

    private static /* synthetic */ Iterator lambda$hierarchy$5(Iterable object) {
        HashSet hashSet = new HashSet();
        object = object.iterator();
        return new ClassUtils$2((Iterator)object, hashSet);
    }

    static {
        NAME_PRIMITIVE_MAP.put(Boolean.TYPE.getName(), Boolean.TYPE);
        NAME_PRIMITIVE_MAP.put(Byte.TYPE.getName(), Byte.TYPE);
        NAME_PRIMITIVE_MAP.put(Character.TYPE.getName(), Character.TYPE);
        NAME_PRIMITIVE_MAP.put(Double.TYPE.getName(), Double.TYPE);
        NAME_PRIMITIVE_MAP.put(Float.TYPE.getName(), Float.TYPE);
        NAME_PRIMITIVE_MAP.put(Integer.TYPE.getName(), Integer.TYPE);
        NAME_PRIMITIVE_MAP.put(Long.TYPE.getName(), Long.TYPE);
        NAME_PRIMITIVE_MAP.put(Short.TYPE.getName(), Short.TYPE);
        NAME_PRIMITIVE_MAP.put(Void.TYPE.getName(), Void.TYPE);
        PRIMITIVE_WRAPPER_MAP = new HashMap();
        PRIMITIVE_WRAPPER_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_WRAPPER_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPER_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_WRAPPER_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_WRAPPER_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPER_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPER_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPER_MAP.put(Float.TYPE, Float.class);
        Class<Void> clazz3 = Void.TYPE;
        PRIMITIVE_WRAPPER_MAP.put(clazz3, clazz3);
        WRAPPER_PRIMITIVE_MAP = new HashMap();
        PRIMITIVE_WRAPPER_MAP.forEach((clazz, clazz2) -> {
            if (!clazz.equals(clazz2)) {
                WRAPPER_PRIMITIVE_MAP.put((Class<?>)clazz2, (Class<?>)clazz);
            }
        });
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Integer.TYPE.getName(), "I");
        hashMap.put(Boolean.TYPE.getName(), "Z");
        hashMap.put(Float.TYPE.getName(), "F");
        hashMap.put(Long.TYPE.getName(), "J");
        hashMap.put(Short.TYPE.getName(), "S");
        hashMap.put(Byte.TYPE.getName(), "B");
        hashMap.put(Double.TYPE.getName(), "D");
        hashMap.put(Character.TYPE.getName(), "C");
        ABBREVIATION_MAP = Collections.unmodifiableMap(hashMap);
        REVERSE_ABBREVIATION_MAP = Collections.unmodifiableMap(hashMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)));
    }
}

