/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SystemProperties;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.stream.Streams;

public class EnumUtils {
    private static final String CANNOT_STORE_S_S_VALUES_IN_S_BITS = "Cannot store %s %s values in %s bits";
    private static final String ENUM_CLASS_MUST_BE_DEFINED = "EnumClass must be defined.";
    private static final String NULL_ELEMENTS_NOT_PERMITTED = "null elements not permitted";
    private static final String S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE = "%s does not seem to be an Enum type";

    private static <E extends Enum<E>> Class<E> asEnum(Class<E> clazz) {
        Objects.requireNonNull(clazz, ENUM_CLASS_MUST_BE_DEFINED);
        Validate.isTrue(clazz.isEnum(), S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE, clazz);
        return clazz;
    }

    private static <E extends Enum<E>> Class<E> checkBitVectorable(Class<E> clazz) {
        Enum[] enumArray = (Enum[])EnumUtils.asEnum(clazz).getEnumConstants();
        Validate.isTrue(enumArray.length <= 64, CANNOT_STORE_S_S_VALUES_IN_S_BITS, enumArray.length, clazz.getSimpleName(), 64);
        return clazz;
    }

    @SafeVarargs
    public static <E extends Enum<E>> long generateBitVector(Class<E> clazz, E ... EArray) {
        Validate.noNullElements(EArray);
        return EnumUtils.generateBitVector(clazz, Arrays.asList(EArray));
    }

    public static <E extends Enum<E>> long generateBitVector(Class<E> object, Iterable<? extends E> object2) {
        EnumUtils.checkBitVectorable(object);
        Objects.requireNonNull(object2, "values");
        long l2 = 0L;
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (Enum)object.next();
            Objects.requireNonNull(object2, NULL_ELEMENTS_NOT_PERMITTED);
            l2 |= 1L << ((Enum)object2).ordinal();
        }
        return l2;
    }

    @SafeVarargs
    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> object, E ... object2) {
        EnumUtils.asEnum(object);
        Validate.noNullElements(object2);
        Object object3 = EnumSet.noneOf(object);
        Collections.addAll(object3, object2);
        object = new long[(((Enum[])((Class)object).getEnumConstants()).length - 1) / 64 + 1];
        object2 = ((AbstractCollection)object3).iterator();
        while (object2.hasNext()) {
            object3 = (Enum)object2.next();
            Object object4 = object;
            int n2 = ((Enum)object3).ordinal() / 64;
            object4[n2] = object4[n2] | 1L << ((Enum)object3).ordinal() % 64;
        }
        ArrayUtils.reverse((long[])object);
        return object;
    }

    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> object, Iterable<? extends E> object2) {
        EnumUtils.asEnum(object);
        Objects.requireNonNull(object2, "values");
        Object object3 = EnumSet.noneOf(object);
        object2.forEach(enum_ -> object3.add(Objects.requireNonNull(enum_, NULL_ELEMENTS_NOT_PERMITTED)));
        object = new long[(((Enum[])((Class)object).getEnumConstants()).length - 1) / 64 + 1];
        object2 = ((AbstractCollection)object3).iterator();
        while (object2.hasNext()) {
            object3 = (Enum)object2.next();
            Object object4 = object;
            int n2 = ((Enum)object3).ordinal() / 64;
            object4[n2] = object4[n2] | 1L << ((Enum)object3).ordinal() % 64;
        }
        ArrayUtils.reverse((long[])object);
        return object;
    }

    public static <E extends Enum<E>> E getEnum(Class<E> clazz, String string) {
        return EnumUtils.getEnum(clazz, string, null);
    }

    public static <E extends Enum<E>> E getEnum(Class<E> clazz, String string, E e2) {
        if (clazz == null || string == null) {
            return e2;
        }
        try {
            return Enum.valueOf(clazz, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return e2;
        }
    }

    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<E> clazz, String string) {
        return EnumUtils.getEnumIgnoreCase(clazz, string, null);
    }

    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<E> clazz, String string, E e2) {
        return (E)EnumUtils.getFirstEnumIgnoreCase(clazz, string, Enum::name, e2);
    }

    public static <E extends Enum<E>> List<E> getEnumList(Class<E> clazz) {
        return new ArrayList<Enum>(Arrays.asList((Enum[])clazz.getEnumConstants()));
    }

    public static <E extends Enum<E>> Map<String, E> getEnumMap(Class<E> clazz) {
        return EnumUtils.getEnumMap(clazz, Enum::name);
    }

    public static <E extends Enum<E>, K> Map<K, E> getEnumMap(Class<E> clazz, Function<E, K> function) {
        return EnumUtils.stream(clazz).collect(Collectors.toMap(function::apply, Function.identity()));
    }

    public static <E extends Enum<E>> E getEnumSystemProperty(Class<E> clazz, String string, E e2) {
        return EnumUtils.getEnum(clazz, SystemProperties.getProperty(string), e2);
    }

    public static <E extends Enum<E>> E getFirstEnum(Class<E> clazz, int n2, ToIntFunction<E> toIntFunction, E e2) {
        if (EnumUtils.isEnum(clazz)) {
            return e2;
        }
        return (E)EnumUtils.stream(clazz).filter(enum_ -> n2 == toIntFunction.applyAsInt(enum_)).findFirst().orElse(e2);
    }

    public static <E extends Enum<E>> E getFirstEnumIgnoreCase(Class<E> clazz, String string, Function<E, String> function, E e2) {
        if (string == null) {
            return e2;
        }
        return (E)EnumUtils.stream(clazz).filter(enum_ -> string.equalsIgnoreCase((String)function.apply(enum_))).findFirst().orElse(e2);
    }

    private static <E extends Enum<E>> boolean isEnum(Class<E> clazz) {
        return clazz != null && !clazz.isEnum();
    }

    public static <E extends Enum<E>> boolean isValidEnum(Class<E> clazz, String string) {
        return EnumUtils.getEnum(clazz, string) != null;
    }

    public static <E extends Enum<E>> boolean isValidEnumIgnoreCase(Class<E> clazz, String string) {
        return EnumUtils.getEnumIgnoreCase(clazz, string) != null;
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVector(Class<E> clazz, long l2) {
        return EnumUtils.processBitVectors(EnumUtils.checkBitVectorable(clazz), l2);
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVectors(Class<E> clazz, long ... lArray) {
        EnumSet enumSet = EnumSet.noneOf(EnumUtils.asEnum(clazz));
        lArray = ArrayUtils.clone(Objects.requireNonNull(lArray, "values"));
        ArrayUtils.reverse(lArray);
        EnumUtils.stream(clazz).forEach(enum_ -> {
            int n2 = enum_.ordinal() / 64;
            if (n2 < lArray.length && (lArray[n2] & 1L << enum_.ordinal() % 64) != 0L) {
                enumSet.add(enum_);
            }
        });
        return enumSet;
    }

    public static <T> Stream<T> stream(Class<T> clazz) {
        if (clazz != null) {
            return Streams.of(clazz.getEnumConstants());
        }
        return Stream.empty();
    }

    @Deprecated
    public EnumUtils() {
    }
}

