/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.UncheckedException;

public class RandomUtils {
    private static RandomUtils INSECURE = new RandomUtils(ThreadLocalRandom::current);
    private static RandomUtils SECURE = new RandomUtils(SecureRandom::new);
    private static final Supplier<Random> SECURE_STRONG_SUPPLIER = () -> SECURE_RANDOM_STRONG.get();
    private static RandomUtils SECURE_STRONG = new RandomUtils(SECURE_STRONG_SUPPLIER);
    private static final ThreadLocal<SecureRandom> SECURE_RANDOM_STRONG = ThreadLocal.withInitial(() -> {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UncheckedException(noSuchAlgorithmException);
        }
    });
    private final Supplier<Random> random;

    public static RandomUtils insecure() {
        return INSECURE;
    }

    @Deprecated
    public static boolean nextBoolean() {
        return RandomUtils.secure().randomBoolean();
    }

    @Deprecated
    public static byte[] nextBytes(int n2) {
        return RandomUtils.secure().randomBytes(n2);
    }

    @Deprecated
    public static double nextDouble() {
        return RandomUtils.secure().randomDouble();
    }

    @Deprecated
    public static double nextDouble(double d2, double d3) {
        return RandomUtils.secure().randomDouble(d2, d3);
    }

    @Deprecated
    public static float nextFloat() {
        return RandomUtils.secure().randomFloat();
    }

    @Deprecated
    public static float nextFloat(float f2, float f3) {
        return RandomUtils.secure().randomFloat(f2, f3);
    }

    @Deprecated
    public static int nextInt() {
        return RandomUtils.secure().randomInt();
    }

    @Deprecated
    public static int nextInt(int n2, int n3) {
        return RandomUtils.secure().randomInt(n2, n3);
    }

    @Deprecated
    public static long nextLong() {
        return RandomUtils.secure().randomLong();
    }

    @Deprecated
    public static long nextLong(long l2, long l3) {
        return RandomUtils.secure().randomLong(l2, l3);
    }

    public static RandomUtils secure() {
        return SECURE;
    }

    static SecureRandom secureRandom() {
        return SECURE_RANDOM_STRONG.get();
    }

    public static RandomUtils secureStrong() {
        return SECURE_STRONG;
    }

    @Deprecated
    public RandomUtils() {
        this(SECURE_STRONG_SUPPLIER);
    }

    private RandomUtils(Supplier<Random> supplier) {
        this.random = supplier;
    }

    Random random() {
        return this.random.get();
    }

    public boolean randomBoolean() {
        return this.random().nextBoolean();
    }

    public byte[] randomBytes(int n2) {
        Validate.isTrue(n2 >= 0, "Count cannot be negative.", new Object[0]);
        byte[] byArray = new byte[n2];
        this.random().nextBytes(byArray);
        return byArray;
    }

    public double randomDouble() {
        return this.randomDouble(0.0, Double.MAX_VALUE);
    }

    public double randomDouble(double d2, double d3) {
        Validate.isTrue(d3 >= d2, "Start value must be smaller or equal to end value.", new Object[0]);
        Validate.isTrue(d2 >= 0.0, "Both range values must be non-negative.", new Object[0]);
        if (d2 == d3) {
            return d2;
        }
        return d2 + (d3 - d2) * this.random().nextDouble();
    }

    public float randomFloat() {
        return this.randomFloat(0.0f, Float.MAX_VALUE);
    }

    public float randomFloat(float f2, float f3) {
        Validate.isTrue(f3 >= f2, "Start value must be smaller or equal to end value.", new Object[0]);
        Validate.isTrue(f2 >= 0.0f, "Both range values must be non-negative.", new Object[0]);
        if (f2 == f3) {
            return f2;
        }
        return f2 + (f3 - f2) * this.random().nextFloat();
    }

    public int randomInt() {
        return this.randomInt(0, Integer.MAX_VALUE);
    }

    public int randomInt(int n2, int n3) {
        Validate.isTrue(n3 >= n2, "Start value must be smaller or equal to end value.", new Object[0]);
        Validate.isTrue(n2 >= 0, "Both range values must be non-negative.", new Object[0]);
        if (n2 == n3) {
            return n2;
        }
        return n2 + this.random().nextInt(n3 - n2);
    }

    public long randomLong() {
        return this.randomLong(Long.MAX_VALUE);
    }

    private long randomLong(long l2) {
        long l3;
        long l4;
        while ((l4 = this.random().nextLong() >>> 1) - (l3 = l4 % l2) + l2 - 1L < 0L) {
        }
        return l3;
    }

    public long randomLong(long l2, long l3) {
        Validate.isTrue(l3 >= l2, "Start value must be smaller or equal to end value.", new Object[0]);
        Validate.isTrue(l2 >= 0L, "Both range values must be non-negative.", new Object[0]);
        if (l2 == l3) {
            return l2;
        }
        return l2 + this.randomLong(l3 - l2);
    }

    public String toString() {
        return "RandomUtils [random=" + this.random() + "]";
    }
}

