/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;

public class RegExUtils {
    static final Pattern VERSION_SPLIT_PATTERN = Pattern.compile("\\.");

    public static Pattern dotAll(String string) {
        return Pattern.compile(string, 32);
    }

    public static Matcher dotAllMatcher(String string, CharSequence charSequence) {
        return RegExUtils.dotAll(string).matcher(charSequence);
    }

    @Deprecated
    public static Matcher dotAllMatcher(String string, String string2) {
        return RegExUtils.dotAll(string).matcher(string2);
    }

    public static String removeAll(CharSequence charSequence, Pattern pattern) {
        return RegExUtils.replaceAll(charSequence, pattern, "");
    }

    @Deprecated
    public static String removeAll(String string, Pattern pattern) {
        return RegExUtils.replaceAll((CharSequence)string, pattern, "");
    }

    public static String removeAll(String string, String string2) {
        return RegExUtils.replaceAll(string, string2, "");
    }

    public static String removeFirst(CharSequence charSequence, Pattern pattern) {
        return RegExUtils.replaceFirst(charSequence, pattern, "");
    }

    @Deprecated
    public static String removeFirst(String string, Pattern pattern) {
        return RegExUtils.replaceFirst(string, pattern, "");
    }

    public static String removeFirst(String string, String string2) {
        return RegExUtils.replaceFirst(string, string2, "");
    }

    public static String removePattern(CharSequence charSequence, String string) {
        return RegExUtils.replacePattern(charSequence, string, "");
    }

    @Deprecated
    public static String removePattern(String string, String string2) {
        return RegExUtils.replacePattern((CharSequence)string, string2, "");
    }

    public static String replaceAll(CharSequence charSequence, Pattern pattern, String string) {
        if (ObjectUtils.anyNull(charSequence, pattern, string)) {
            return RegExUtils.toStringOrNull(charSequence);
        }
        return pattern.matcher(charSequence).replaceAll(string);
    }

    @Deprecated
    public static String replaceAll(String string, Pattern pattern, String string2) {
        return RegExUtils.replaceAll((CharSequence)string, pattern, string2);
    }

    public static String replaceAll(String string, String string2, String string3) {
        if (ObjectUtils.anyNull(string, string2, string3)) {
            return string;
        }
        return string.replaceAll(string2, string3);
    }

    public static String replaceFirst(CharSequence charSequence, Pattern pattern, String string) {
        if (charSequence == null || pattern == null || string == null) {
            return RegExUtils.toStringOrNull(charSequence);
        }
        return pattern.matcher(charSequence).replaceFirst(string);
    }

    @Deprecated
    public static String replaceFirst(String string, Pattern pattern, String string2) {
        return RegExUtils.replaceFirst((CharSequence)string, pattern, string2);
    }

    public static String replaceFirst(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return string;
        }
        return string.replaceFirst(string2, string3);
    }

    public static String replacePattern(CharSequence charSequence, String string, String string2) {
        if (ObjectUtils.anyNull(charSequence, string, string2)) {
            return RegExUtils.toStringOrNull(charSequence);
        }
        return RegExUtils.dotAllMatcher(string, charSequence).replaceAll(string2);
    }

    @Deprecated
    public static String replacePattern(String string, String string2, String string3) {
        return RegExUtils.replacePattern((CharSequence)string, string2, string3);
    }

    private static String toStringOrNull(CharSequence charSequence) {
        return Objects.toString(charSequence, null);
    }

    @Deprecated
    public RegExUtils() {
    }
}

