/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ThreadUtils$AlwaysTruePredicate;
import org.apache.commons.lang3.ThreadUtils$ThreadGroupPredicate;
import org.apache.commons.lang3.ThreadUtils$ThreadPredicate;
import org.apache.commons.lang3.function.Predicates;
import org.apache.commons.lang3.time.DurationUtils;

public class ThreadUtils {
    @Deprecated
    public static final ThreadUtils$AlwaysTruePredicate ALWAYS_TRUE_PREDICATE = new ThreadUtils$AlwaysTruePredicate(null);

    public static Thread findThreadById(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("The thread id must be greater than zero");
        }
        Collection<Thread> collection = ThreadUtils.findThreads((Thread thread) -> thread != null && thread.getId() == l2);
        if (collection.isEmpty()) {
            return null;
        }
        return collection.iterator().next();
    }

    public static Thread findThreadById(long l2, String string) {
        Objects.requireNonNull(string, "threadGroupName");
        Thread thread = ThreadUtils.findThreadById(l2);
        if (thread != null && thread.getThreadGroup() != null && thread.getThreadGroup().getName().equals(string)) {
            return thread;
        }
        return null;
    }

    public static Thread findThreadById(long l2, ThreadGroup threadGroup) {
        Objects.requireNonNull(threadGroup, "threadGroup");
        Thread thread = ThreadUtils.findThreadById(l2);
        if (thread != null && threadGroup.equals(thread.getThreadGroup())) {
            return thread;
        }
        return null;
    }

    public static Collection<ThreadGroup> findThreadGroups(Predicate<ThreadGroup> predicate) {
        return ThreadUtils.findThreadGroups(ThreadUtils.getSystemThreadGroup(), true, predicate);
    }

    public static Collection<ThreadGroup> findThreadGroups(ThreadGroup threadGroup, boolean bl2, Predicate<ThreadGroup> predicate) {
        int n2;
        ThreadGroup[] threadGroupArray;
        Objects.requireNonNull(threadGroup, "threadGroup");
        Objects.requireNonNull(predicate, "predicate");
        int n3 = threadGroup.activeGroupCount();
        do {
            n2 = n3;
        } while ((n3 = threadGroup.enumerate(threadGroupArray = new ThreadGroup[n2 + n2 / 2 + 1], bl2)) >= threadGroupArray.length);
        return Collections.unmodifiableCollection(Stream.of(threadGroupArray).limit(n3).filter(predicate).collect(Collectors.toList()));
    }

    @Deprecated
    public static Collection<ThreadGroup> findThreadGroups(ThreadGroup threadGroup, boolean bl2, ThreadUtils$ThreadGroupPredicate threadUtils$ThreadGroupPredicate) {
        return ThreadUtils.findThreadGroups(threadGroup, bl2, threadUtils$ThreadGroupPredicate::test);
    }

    @Deprecated
    public static Collection<ThreadGroup> findThreadGroups(ThreadUtils$ThreadGroupPredicate threadUtils$ThreadGroupPredicate) {
        return ThreadUtils.findThreadGroups(ThreadUtils.getSystemThreadGroup(), true, threadUtils$ThreadGroupPredicate);
    }

    public static Collection<ThreadGroup> findThreadGroupsByName(String string) {
        return ThreadUtils.findThreadGroups(ThreadUtils.predicateThreadGroup(string));
    }

    public static Collection<Thread> findThreads(Predicate<Thread> predicate) {
        return ThreadUtils.findThreads(ThreadUtils.getSystemThreadGroup(), true, predicate);
    }

    public static Collection<Thread> findThreads(ThreadGroup threadGroup, boolean bl2, Predicate<Thread> predicate) {
        int n2;
        Thread[] threadArray;
        Objects.requireNonNull(threadGroup, "The group must not be null");
        Objects.requireNonNull(predicate, "The predicate must not be null");
        int n3 = threadGroup.activeCount();
        do {
            n2 = n3;
        } while ((n3 = threadGroup.enumerate(threadArray = new Thread[n2 + n2 / 2 + 1], bl2)) >= threadArray.length);
        return Collections.unmodifiableCollection(Stream.of(threadArray).limit(n3).filter(predicate).collect(Collectors.toList()));
    }

    @Deprecated
    public static Collection<Thread> findThreads(ThreadGroup threadGroup, boolean bl2, ThreadUtils$ThreadPredicate threadUtils$ThreadPredicate) {
        return ThreadUtils.findThreads(threadGroup, bl2, threadUtils$ThreadPredicate::test);
    }

    @Deprecated
    public static Collection<Thread> findThreads(ThreadUtils$ThreadPredicate threadUtils$ThreadPredicate) {
        return ThreadUtils.findThreads(ThreadUtils.getSystemThreadGroup(), true, threadUtils$ThreadPredicate);
    }

    public static Collection<Thread> findThreadsByName(String string) {
        return ThreadUtils.findThreads(ThreadUtils.predicateThread(string));
    }

    public static Collection<Thread> findThreadsByName(String string, String string2) {
        Objects.requireNonNull(string, "threadName");
        Objects.requireNonNull(string2, "threadGroupName");
        return Collections.unmodifiableCollection(ThreadUtils.findThreadGroups(ThreadUtils.predicateThreadGroup(string2)).stream().flatMap(threadGroup -> ThreadUtils.findThreads(threadGroup, false, ThreadUtils.predicateThread(string)).stream()).collect(Collectors.toList()));
    }

    public static Collection<Thread> findThreadsByName(String string, ThreadGroup threadGroup) {
        return ThreadUtils.findThreads(threadGroup, false, ThreadUtils.predicateThread(string));
    }

    public static Collection<ThreadGroup> getAllThreadGroups() {
        return ThreadUtils.findThreadGroups(Predicates.truePredicate());
    }

    public static Collection<Thread> getAllThreads() {
        return ThreadUtils.findThreads(Predicates.truePredicate());
    }

    public static ThreadGroup getSystemThreadGroup() {
        ThreadGroup threadGroup;
        for (threadGroup = Thread.currentThread().getThreadGroup(); threadGroup != null && threadGroup.getParent() != null; threadGroup = threadGroup.getParent()) {
        }
        return threadGroup;
    }

    public static void join(Thread thread, Duration duration) throws InterruptedException {
        DurationUtils.accept(thread::join, duration);
    }

    private static <T> Predicate<T> namePredicate(String string, Function<T, String> function) {
        return object -> object != null && Objects.equals(function.apply(object), Objects.requireNonNull(string));
    }

    private static Predicate<Thread> predicateThread(String string) {
        return ThreadUtils.namePredicate(string, Thread::getName);
    }

    private static Predicate<ThreadGroup> predicateThreadGroup(String string) {
        return ThreadUtils.namePredicate(string, ThreadGroup::getName);
    }

    public static void sleep(Duration duration) throws InterruptedException {
        DurationUtils.accept(Thread::sleep, duration);
    }

    public static void sleepQuietly(Duration duration) {
        try {
            ThreadUtils.sleep(duration);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    @Deprecated
    public ThreadUtils() {
    }
}

