/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffBuilder$1;
import org.apache.commons.lang3.builder.DiffBuilder$Builder;
import org.apache.commons.lang3.builder.DiffBuilder$SDiff;
import org.apache.commons.lang3.builder.DiffBuilder$SerializableSupplier;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DiffBuilder<T>
implements Builder<DiffResult<T>> {
    static final String TO_STRING_FORMAT = "%s differs from %s";
    private final List<Diff<?>> diffs;
    private final boolean equals;
    private final T left;
    private final T right;
    private final ToStringStyle style;
    private final String toStringFormat;

    public static <T> DiffBuilder$Builder<T> builder() {
        return new DiffBuilder$Builder();
    }

    @Deprecated
    public DiffBuilder(T t2, T t3, ToStringStyle toStringStyle) {
        this(t2, t3, toStringStyle, true);
    }

    @Deprecated
    public DiffBuilder(T t2, T t3, ToStringStyle toStringStyle, boolean bl2) {
        this(t2, t3, toStringStyle, bl2, TO_STRING_FORMAT);
    }

    private DiffBuilder(T t2, T t3, ToStringStyle toStringStyle, boolean bl2, String string) {
        this.left = Objects.requireNonNull(t2, "left");
        this.right = Objects.requireNonNull(t3, "right");
        this.diffs = new ArrayList();
        this.toStringFormat = string;
        this.style = toStringStyle != null ? toStringStyle : ToStringStyle.DEFAULT_STYLE;
        this.equals = bl2 && Objects.equals(t2, t3);
    }

    private <F> DiffBuilder<T> add(String string, DiffBuilder$SerializableSupplier<F> diffBuilder$SerializableSupplier, DiffBuilder$SerializableSupplier<F> diffBuilder$SerializableSupplier2, Class<F> clazz) {
        this.diffs.add(new DiffBuilder$SDiff(string, diffBuilder$SerializableSupplier, diffBuilder$SerializableSupplier2, clazz, null));
        return this;
    }

    public DiffBuilder<T> append(String string, boolean bl2, boolean bl3) {
        if (this.equals || bl2 == bl3) {
            return this;
        }
        return this.add(string, () -> bl2, () -> bl3, Boolean.class);
    }

    public DiffBuilder<T> append(String string, boolean[] blArray, boolean[] blArray2) {
        if (this.equals || Arrays.equals(blArray, blArray2)) {
            return this;
        }
        return this.add(string, () -> ArrayUtils.toObject(blArray), () -> ArrayUtils.toObject(blArray2), Boolean[].class);
    }

    public DiffBuilder<T> append(String string, byte by2, byte by3) {
        if (this.equals || by2 == by3) {
            return this;
        }
        return this.add(string, () -> by2, () -> by3, Byte.class);
    }

    public DiffBuilder<T> append(String string, byte[] byArray, byte[] byArray2) {
        if (this.equals || Arrays.equals(byArray, byArray2)) {
            return this;
        }
        return this.add(string, () -> ArrayUtils.toObject(byArray), () -> ArrayUtils.toObject(byArray2), Byte[].class);
    }

    public DiffBuilder<T> append(String string, char c2, char c3) {
        if (this.equals || c2 == c3) {
            return this;
        }
        return this.add(string, () -> Character.valueOf(c2), () -> Character.valueOf(c3), Character.class);
    }

    public DiffBuilder<T> append(String string, char[] cArray, char[] cArray2) {
        if (this.equals || Arrays.equals(cArray, cArray2)) {
            return this;
        }
        return this.add(string, () -> ArrayUtils.toObject(cArray), () -> ArrayUtils.toObject(cArray2), Character[].class);
    }

    public DiffBuilder<T> append(String string, DiffResult<?> diffResult) {
        Objects.requireNonNull(diffResult, "diffResult");
        if (this.equals) {
            return this;
        }
        diffResult.getDiffs().forEach(diff -> this.append(string + "." + diff.getFieldName(), diff.getLeft(), diff.getRight()));
        return this;
    }

    public DiffBuilder<T> append(String string, double d2, double d3) {
        if (this.equals || Double.doubleToLongBits(d2) == Double.doubleToLongBits(d3)) {
            return this;
        }
        return this.add(string, () -> d2, () -> d3, Double.class);
    }

    public DiffBuilder<T> append(String string, double[] dArray, double[] dArray2) {
        if (this.equals || Arrays.equals(dArray, dArray2)) {
            return this;
        }
        return this.add(string, () -> ArrayUtils.toObject(dArray), () -> ArrayUtils.toObject(dArray2), Double[].class);
    }

    public DiffBuilder<T> append(String string, float f2, float f3) {
        if (this.equals || Float.floatToIntBits(f2) == Float.floatToIntBits(f3)) {
            return this;
        }
        return this.add(string, () -> Float.valueOf(f2), () -> Float.valueOf(f3), Float.class);
    }

    public DiffBuilder<T> append(String string, float[] fArray, float[] fArray2) {
        if (this.equals || Arrays.equals(fArray, fArray2)) {
            return this;
        }
        return this.add(string, () -> ArrayUtils.toObject(fArray), () -> ArrayUtils.toObject(fArray2), Float[].class);
    }

    public DiffBuilder<T> append(String string, int n2, int n3) {
        if (this.equals || n2 == n3) {
            return this;
        }
        return this.add(string, () -> n2, () -> n3, Integer.class);
    }

    public DiffBuilder<T> append(String string, int[] nArray, int[] nArray2) {
        if (this.equals || Arrays.equals(nArray, nArray2)) {
            return this;
        }
        return this.add(string, () -> ArrayUtils.toObject(nArray), () -> ArrayUtils.toObject(nArray2), Integer[].class);
    }

    public DiffBuilder<T> append(String string, long l2, long l3) {
        if (this.equals || l2 == l3) {
            return this;
        }
        return this.add(string, () -> l2, () -> l3, Long.class);
    }

    public DiffBuilder<T> append(String string, long[] lArray, long[] lArray2) {
        if (this.equals || Arrays.equals(lArray, lArray2)) {
            return this;
        }
        return this.add(string, () -> ArrayUtils.toObject(lArray), () -> ArrayUtils.toObject(lArray2), Long[].class);
    }

    public DiffBuilder<T> append(String string, Object object, Object object2) {
        if (this.equals || object == object2) {
            return this;
        }
        Object object3 = object != null ? object : object2;
        if (ObjectUtils.isArray(object3)) {
            if (object3 instanceof boolean[]) {
                return this.append(string, (boolean[])object, (boolean[])object2);
            }
            if (object3 instanceof byte[]) {
                return this.append(string, (byte[])object, (byte[])object2);
            }
            if (object3 instanceof char[]) {
                return this.append(string, (char[])object, (char[])object2);
            }
            if (object3 instanceof double[]) {
                return this.append(string, (double[])object, (double[])object2);
            }
            if (object3 instanceof float[]) {
                return this.append(string, (float[])object, (float[])object2);
            }
            if (object3 instanceof int[]) {
                return this.append(string, (int[])object, (int[])object2);
            }
            if (object3 instanceof long[]) {
                return this.append(string, (long[])object, (long[])object2);
            }
            if (object3 instanceof short[]) {
                return this.append(string, (short[])object, (short[])object2);
            }
            return this.append(string, (Object[])object, (Object[])object2);
        }
        if (Objects.equals(object, object2)) {
            return this;
        }
        return this.add(string, () -> object, () -> object2, Object.class);
    }

    public DiffBuilder<T> append(String string, Object[] objectArray, Object[] objectArray2) {
        if (this.equals || Arrays.equals(objectArray, objectArray2)) {
            return this;
        }
        return this.add(string, () -> objectArray, () -> objectArray2, Object[].class);
    }

    public DiffBuilder<T> append(String string, short s2, short s3) {
        if (this.equals || s2 == s3) {
            return this;
        }
        return this.add(string, () -> s2, () -> s3, Short.class);
    }

    public DiffBuilder<T> append(String string, short[] sArray, short[] sArray2) {
        if (this.equals || Arrays.equals(sArray, sArray2)) {
            return this;
        }
        return this.add(string, () -> ArrayUtils.toObject(sArray), () -> ArrayUtils.toObject(sArray2), Short[].class);
    }

    @Override
    public DiffResult<T> build() {
        return new DiffResult<T>(this.left, this.right, this.diffs, this.style, this.toStringFormat);
    }

    T getLeft() {
        return this.left;
    }

    T getRight() {
        return this.right;
    }

    /* synthetic */ DiffBuilder(Object object, Object object2, ToStringStyle toStringStyle, boolean bl2, String string, DiffBuilder$1 diffBuilder$1) {
        this(object, object2, toStringStyle, bl2, string);
    }
}

