/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.builder.ToStringStyle;

final class ToStringStyle$JsonToStringStyle
extends ToStringStyle {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_NAME_QUOTE = "\"";

    ToStringStyle$JsonToStringStyle() {
        this.setUseClassName(false);
        this.setUseIdentityHashCode(false);
        this.setContentStart("{");
        this.setContentEnd("}");
        this.setArrayStart("[");
        this.setArrayEnd("]");
        this.setFieldSeparator(",");
        this.setFieldNameValueSeparator(":");
        this.setNullText("null");
        this.setSummaryObjectStartText("\"<");
        this.setSummaryObjectEndText(">\"");
        this.setSizeStartText("\"<size=");
        this.setSizeEndText(">\"");
    }

    @Override
    public final void append(StringBuffer stringBuffer, String string, boolean[] blArray, Boolean bl2) {
        this.checkAppendInput(string, bl2);
        super.append(stringBuffer, string, blArray, bl2);
    }

    @Override
    public final void append(StringBuffer stringBuffer, String string, byte[] byArray, Boolean bl2) {
        this.checkAppendInput(string, bl2);
        super.append(stringBuffer, string, byArray, bl2);
    }

    @Override
    public final void append(StringBuffer stringBuffer, String string, char[] cArray, Boolean bl2) {
        this.checkAppendInput(string, bl2);
        super.append(stringBuffer, string, cArray, bl2);
    }

    @Override
    public final void append(StringBuffer stringBuffer, String string, double[] dArray, Boolean bl2) {
        this.checkAppendInput(string, bl2);
        super.append(stringBuffer, string, dArray, bl2);
    }

    @Override
    public final void append(StringBuffer stringBuffer, String string, float[] fArray, Boolean bl2) {
        this.checkAppendInput(string, bl2);
        super.append(stringBuffer, string, fArray, bl2);
    }

    @Override
    public final void append(StringBuffer stringBuffer, String string, int[] nArray, Boolean bl2) {
        this.checkAppendInput(string, bl2);
        super.append(stringBuffer, string, nArray, bl2);
    }

    @Override
    public final void append(StringBuffer stringBuffer, String string, long[] lArray, Boolean bl2) {
        this.checkAppendInput(string, bl2);
        super.append(stringBuffer, string, lArray, bl2);
    }

    @Override
    public final void append(StringBuffer stringBuffer, String string, Object object, Boolean bl2) {
        this.checkAppendInput(string, bl2);
        super.append(stringBuffer, string, object, bl2);
    }

    @Override
    public final void append(StringBuffer stringBuffer, String string, Object[] objectArray, Boolean bl2) {
        this.checkAppendInput(string, bl2);
        super.append(stringBuffer, string, objectArray, bl2);
    }

    @Override
    public final void append(StringBuffer stringBuffer, String string, short[] sArray, Boolean bl2) {
        this.checkAppendInput(string, bl2);
        super.append(stringBuffer, string, sArray, bl2);
    }

    @Override
    protected final void appendDetail(StringBuffer stringBuffer, String string, char c2) {
        this.appendValueAsString(stringBuffer, String.valueOf(c2));
    }

    @Override
    protected final void appendDetail(StringBuffer stringBuffer, String string, Collection<?> object) {
        if (object != null && !object.isEmpty()) {
            stringBuffer.append(this.getArrayStart());
            int n2 = 0;
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                this.appendDetail(stringBuffer, string, n2++, e2);
            }
            stringBuffer.append(this.getArrayEnd());
            return;
        }
        stringBuffer.append(object);
    }

    @Override
    protected final void appendDetail(StringBuffer stringBuffer, String string, Map<?, ?> object) {
        if (object != null && !object.isEmpty()) {
            stringBuffer.append(this.getContentStart());
            boolean bl2 = true;
            for (Map.Entry entry : object.entrySet()) {
                String string2 = Objects.toString(entry.getKey(), null);
                if (string2 == null) continue;
                if (bl2) {
                    bl2 = false;
                } else {
                    this.appendFieldEnd(stringBuffer, string2);
                }
                this.appendFieldStart(stringBuffer, string2);
                Object v2 = entry.getValue();
                if (v2 == null) {
                    this.appendNullText(stringBuffer, string2);
                    continue;
                }
                this.appendInternal(stringBuffer, string2, v2, true);
            }
            stringBuffer.append(this.getContentEnd());
            return;
        }
        stringBuffer.append(object);
    }

    @Override
    protected final void appendDetail(StringBuffer stringBuffer, String string, Object object) {
        while (true) {
            if (object == null) {
                this.appendNullText(stringBuffer, string);
                return;
            }
            if (object instanceof String || object instanceof Character) {
                this.appendValueAsString(stringBuffer, object.toString());
                return;
            }
            if (object instanceof Number || object instanceof Boolean) {
                stringBuffer.append(object);
                return;
            }
            String string2 = object.toString();
            if (this.isJsonObject(string2) || this.isJsonArray(string2)) {
                stringBuffer.append(object);
                return;
            }
            object = string2;
        }
    }

    @Override
    protected final void appendFieldStart(StringBuffer stringBuffer, String string) {
        this.checkFieldName(string);
        super.appendFieldStart(stringBuffer, FIELD_NAME_QUOTE + StringEscapeUtils.escapeJson(string) + FIELD_NAME_QUOTE);
    }

    private void appendValueAsString(StringBuffer stringBuffer, String string) {
        stringBuffer.append('\"').append(StringEscapeUtils.escapeJson(string)).append('\"');
    }

    private void checkAppendInput(String string, Boolean bl2) {
        this.checkFieldName(string);
        this.checkIsFullDetail(bl2);
    }

    private void checkFieldName(String string) {
        if (string == null) {
            throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
        }
    }

    private void checkIsFullDetail(Boolean bl2) {
        if (!this.isFullDetail(bl2)) {
            throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
        }
    }

    private boolean isJsonArray(String string) {
        return string.startsWith(this.getArrayStart()) && string.endsWith(this.getArrayEnd());
    }

    private boolean isJsonObject(String string) {
        return string.startsWith(this.getContentStart()) && string.endsWith(this.getContentEnd());
    }

    private Object readResolve() {
        return JSON_STYLE;
    }
}

