/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.compare;

import java.util.function.Predicate;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.compare.ComparableUtils$ComparableCheckBuilder;

public class ComparableUtils {
    public static <A extends Comparable<A>> Predicate<A> between(A a2, A a3) {
        return comparable3 -> ComparableUtils.is(comparable3).between(a2, a3);
    }

    public static <A extends Comparable<A>> Predicate<A> betweenExclusive(A a2, A a3) {
        return comparable3 -> ComparableUtils.is(comparable3).betweenExclusive(a2, a3);
    }

    public static <A extends Comparable<A>> Predicate<A> ge(A a2) {
        return comparable2 -> ComparableUtils.is(comparable2).greaterThanOrEqualTo(a2);
    }

    public static <A extends Comparable<A>> Predicate<A> gt(A a2) {
        return comparable2 -> ComparableUtils.is(comparable2).greaterThan(a2);
    }

    public static <A extends Comparable<A>> ComparableUtils$ComparableCheckBuilder<A> is(A a2) {
        return new ComparableUtils$ComparableCheckBuilder(a2, null);
    }

    public static <A extends Comparable<A>> Predicate<A> le(A a2) {
        return comparable2 -> ComparableUtils.is(comparable2).lessThanOrEqualTo(a2);
    }

    public static <A extends Comparable<A>> Predicate<A> lt(A a2) {
        return comparable2 -> ComparableUtils.is(comparable2).lessThan(a2);
    }

    public static <A extends Comparable<A>> A max(A a2, A a3) {
        if (ObjectUtils.compare(a2, a3, false) > 0) {
            return a2;
        }
        return a3;
    }

    public static <A extends Comparable<A>> A min(A a2, A a3) {
        if (ObjectUtils.compare(a2, a3, true) < 0) {
            return a2;
        }
        return a3;
    }

    private ComparableUtils() {
    }
}

