/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializer;
import org.apache.commons.lang3.concurrent.AtomicInitializer$1;
import org.apache.commons.lang3.concurrent.AtomicInitializer$Builder;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableSupplier;

public class AtomicInitializer<T>
extends AbstractConcurrentInitializer<T, ConcurrentException> {
    private static final Object NO_INIT = new Object();
    private final AtomicReference<T> reference = new AtomicReference<T>(this.getNoInit());

    public static <T> AtomicInitializer$Builder<AtomicInitializer<T>, T> builder() {
        return new AtomicInitializer$Builder();
    }

    public AtomicInitializer() {
    }

    private AtomicInitializer(FailableSupplier<T, ConcurrentException> failableSupplier, FailableConsumer<T, ConcurrentException> failableConsumer) {
        super(failableSupplier, failableConsumer);
    }

    @Override
    public T get() throws ConcurrentException {
        T t2 = this.reference.get();
        if (t2 == this.getNoInit()) {
            t2 = this.initialize();
            if (!this.reference.compareAndSet(this.getNoInit(), t2)) {
                t2 = this.reference.get();
            }
        }
        return t2;
    }

    private T getNoInit() {
        return (T)NO_INIT;
    }

    @Override
    protected ConcurrentException getTypedException(Exception exception) {
        return new ConcurrentException(exception);
    }

    @Override
    public boolean isInitialized() {
        return this.reference.get() != NO_INIT;
    }

    /* synthetic */ AtomicInitializer(FailableSupplier failableSupplier, FailableConsumer failableConsumer, AtomicInitializer$1 atomicInitializer$1) {
        this(failableSupplier, failableConsumer);
    }
}

