/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.concurrent.BasicThreadFactory$1;
import org.apache.commons.lang3.concurrent.BasicThreadFactory$Builder;

public class BasicThreadFactory
implements ThreadFactory {
    private final AtomicLong threadCounter;
    private final ThreadFactory wrappedFactory;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final String namingPattern;
    private final Integer priority;
    private final Boolean daemon;

    public static BasicThreadFactory$Builder builder() {
        return new BasicThreadFactory$Builder();
    }

    private BasicThreadFactory(BasicThreadFactory$Builder basicThreadFactory$Builder) {
        this.wrappedFactory = BasicThreadFactory$Builder.access$100(basicThreadFactory$Builder) != null ? BasicThreadFactory$Builder.access$100(basicThreadFactory$Builder) : Executors.defaultThreadFactory();
        this.namingPattern = BasicThreadFactory$Builder.access$200(basicThreadFactory$Builder);
        this.priority = BasicThreadFactory$Builder.access$300(basicThreadFactory$Builder);
        this.daemon = BasicThreadFactory$Builder.access$400(basicThreadFactory$Builder);
        this.uncaughtExceptionHandler = BasicThreadFactory$Builder.access$500(basicThreadFactory$Builder);
        this.threadCounter = new AtomicLong();
    }

    public final Boolean getDaemonFlag() {
        return this.daemon;
    }

    public final String getNamingPattern() {
        return this.namingPattern;
    }

    public final Integer getPriority() {
        return this.priority;
    }

    public long getThreadCount() {
        return this.threadCounter.get();
    }

    public final Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public final ThreadFactory getWrappedFactory() {
        return this.wrappedFactory;
    }

    private void initializeThread(Thread thread) {
        if (this.getNamingPattern() != null) {
            Long l2 = this.threadCounter.incrementAndGet();
            thread.setName(String.format(this.getNamingPattern(), l2));
        }
        if (this.getUncaughtExceptionHandler() != null) {
            thread.setUncaughtExceptionHandler(this.getUncaughtExceptionHandler());
        }
        if (this.getPriority() != null) {
            thread.setPriority(this.getPriority());
        }
        if (this.getDaemonFlag() != null) {
            thread.setDaemon(this.getDaemonFlag());
        }
    }

    @Override
    public Thread newThread(Runnable runnable) {
        runnable = this.getWrappedFactory().newThread(runnable);
        this.initializeThread((Thread)runnable);
        return runnable;
    }

    /* synthetic */ BasicThreadFactory(BasicThreadFactory$Builder basicThreadFactory$Builder, BasicThreadFactory$1 basicThreadFactory$1) {
        this(basicThreadFactory$Builder);
    }
}

