/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer$1;
import org.apache.commons.lang3.concurrent.LazyInitializer$Builder;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableSupplier;

public class LazyInitializer<T>
extends AbstractConcurrentInitializer<T, ConcurrentException> {
    private static final Object NO_INIT = new Object();
    private volatile T object = NO_INIT;

    public static <T> LazyInitializer$Builder<LazyInitializer<T>, T> builder() {
        return new LazyInitializer$Builder();
    }

    public LazyInitializer() {
    }

    private LazyInitializer(FailableSupplier<T, ConcurrentException> failableSupplier, FailableConsumer<T, ConcurrentException> failableConsumer) {
        super(failableSupplier, failableConsumer);
    }

    @Override
    public T get() throws ConcurrentException {
        T t2 = this.object;
        if (t2 == NO_INIT) {
            LazyInitializer lazyInitializer = this;
            synchronized (lazyInitializer) {
                t2 = this.object;
                if (t2 == NO_INIT) {
                    this.object = t2 = this.initialize();
                }
            }
        }
        return t2;
    }

    @Override
    protected ConcurrentException getTypedException(Exception exception) {
        return new ConcurrentException(exception);
    }

    @Override
    public boolean isInitialized() {
        return this.object != NO_INIT;
    }

    /* synthetic */ LazyInitializer(FailableSupplier failableSupplier, FailableConsumer failableConsumer, LazyInitializer$1 lazyInitializer$1) {
        this(failableSupplier, failableConsumer);
    }
}

