/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.concurrent.BackgroundInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.MultiBackgroundInitializer$MultiBackgroundInitializerResults;

public class MultiBackgroundInitializer
extends BackgroundInitializer<MultiBackgroundInitializer$MultiBackgroundInitializerResults> {
    private final Map<String, BackgroundInitializer<?>> childInitializers = new HashMap();

    public MultiBackgroundInitializer() {
    }

    public MultiBackgroundInitializer(ExecutorService executorService) {
        super(executorService);
    }

    public void addInitializer(String string, BackgroundInitializer<?> backgroundInitializer) {
        Objects.requireNonNull(string, "name");
        Objects.requireNonNull(backgroundInitializer, "backgroundInitializer");
        MultiBackgroundInitializer multiBackgroundInitializer = this;
        synchronized (multiBackgroundInitializer) {
            if (this.isStarted()) {
                throw new IllegalStateException("addInitializer() must not be called after start()!");
            }
            this.childInitializers.put(string, backgroundInitializer);
            return;
        }
    }

    @Override
    public void close() throws ConcurrentException {
        ConcurrentException concurrentException = null;
        for (BackgroundInitializer<?> backgroundInitializer : this.childInitializers.values()) {
            try {
                backgroundInitializer.close();
            }
            catch (Exception exception) {
                if (concurrentException == null) {
                    concurrentException = new ConcurrentException();
                }
                if (exception instanceof ConcurrentException) {
                    concurrentException.addSuppressed(exception.getCause());
                    continue;
                }
                concurrentException.addSuppressed(exception);
            }
        }
        if (concurrentException != null) {
            throw concurrentException;
        }
    }

    @Override
    protected int getTaskCount() {
        return 1 + this.childInitializers.values().stream().mapToInt(BackgroundInitializer::getTaskCount).sum();
    }

    @Override
    protected MultiBackgroundInitializer$MultiBackgroundInitializerResults initialize() throws Exception {
        HashMap hashMap;
        HashMap hashMap2 = this;
        synchronized (hashMap2) {
            hashMap = new HashMap(this.childInitializers);
        }
        hashMap2 = this.getActiveExecutor();
        hashMap.values().forEach(arg_0 -> MultiBackgroundInitializer.lambda$initialize$0((ExecutorService)((Object)hashMap2), arg_0));
        HashMap hashMap3 = new HashMap();
        hashMap2 = new HashMap();
        hashMap.forEach((string, backgroundInitializer) -> {
            try {
                hashMap3.put(string, backgroundInitializer.get());
                return;
            }
            catch (ConcurrentException concurrentException) {
                hashMap2.put(string, concurrentException);
                return;
            }
        });
        return new MultiBackgroundInitializer$MultiBackgroundInitializerResults(hashMap, hashMap3, hashMap2, null);
    }

    @Override
    public boolean isInitialized() {
        if (this.childInitializers.isEmpty()) {
            return false;
        }
        return this.childInitializers.values().stream().allMatch(BackgroundInitializer::isInitialized);
    }

    private static /* synthetic */ void lambda$initialize$0(ExecutorService executorService, BackgroundInitializer backgroundInitializer) {
        if (backgroundInitializer.getExternalExecutor() == null) {
            backgroundInitializer.setExternalExecutor(executorService);
        }
        backgroundInitializer.start();
    }
}

