/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultExceptionContext
implements Serializable,
ExceptionContext {
    private static final long serialVersionUID = 20110706L;
    private final List<Pair<String, Object>> contextValues = new ArrayList<Pair<String, Object>>();

    @Override
    public DefaultExceptionContext addContextValue(String string, Object object) {
        this.contextValues.add(new ImmutablePair<String, Object>(string, object));
        return this;
    }

    @Override
    public List<Pair<String, Object>> getContextEntries() {
        return this.contextValues;
    }

    @Override
    public Set<String> getContextLabels() {
        return this.stream().map(Pair::getKey).collect(Collectors.toSet());
    }

    @Override
    public List<Object> getContextValues(String string) {
        return this.stream().filter(pair -> Strings.CS.equals(string, (String)pair.getKey())).map(Pair::getValue).collect(Collectors.toList());
    }

    @Override
    public Object getFirstContextValue(String string) {
        return this.stream().filter(pair -> Strings.CS.equals(string, (String)pair.getKey())).findFirst().map(Pair::getValue).orElse(null);
    }

    @Override
    public String getFormattedExceptionMessage(String string) {
        StringBuilder stringBuilder = new StringBuilder(256);
        if (string != null) {
            stringBuilder.append(string);
        }
        if (!this.contextValues.isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("Exception Context:\n");
            int n2 = 0;
            for (Pair<String, Object> exception : this.contextValues) {
                stringBuilder.append("\t[");
                stringBuilder.append(++n2);
                stringBuilder.append(':');
                stringBuilder.append(exception.getKey());
                stringBuilder.append("=");
                Object object = exception.getValue();
                try {
                    stringBuilder.append(Objects.toString(object));
                }
                catch (Exception exception2) {
                    stringBuilder.append("Exception thrown on toString(): ");
                    stringBuilder.append(ExceptionUtils.getStackTrace(exception2));
                }
                stringBuilder.append("]\n");
            }
            stringBuilder.append("---------------------------------");
        }
        return stringBuilder.toString();
    }

    @Override
    public DefaultExceptionContext setContextValue(String string, Object object) {
        this.contextValues.removeIf(pair -> Strings.CS.equals(string, (String)pair.getKey()));
        this.addContextValue(string, object);
        return this;
    }

    private Stream<Pair<String, Object>> stream() {
        return this.contextValues.stream();
    }
}

