/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.function.FailableBiConsumer;
import org.apache.commons.lang3.function.FailableBiFunction;
import org.apache.commons.lang3.function.FailableBiPredicate;
import org.apache.commons.lang3.function.FailableBooleanSupplier;
import org.apache.commons.lang3.function.FailableCallable;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableDoubleBinaryOperator;
import org.apache.commons.lang3.function.FailableDoubleConsumer;
import org.apache.commons.lang3.function.FailableDoubleSupplier;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.function.FailableIntConsumer;
import org.apache.commons.lang3.function.FailableIntSupplier;
import org.apache.commons.lang3.function.FailableLongConsumer;
import org.apache.commons.lang3.function.FailableLongSupplier;
import org.apache.commons.lang3.function.FailablePredicate;
import org.apache.commons.lang3.function.FailableRunnable;
import org.apache.commons.lang3.function.FailableShortSupplier;
import org.apache.commons.lang3.function.FailableSupplier;
import org.apache.commons.lang3.stream.Streams;
import org.apache.commons.lang3.stream.Streams$FailableStream;

public class Failable {
    public static <T, U, E extends Throwable> void accept(FailableBiConsumer<T, U, E> failableBiConsumer, T t2, U u2) {
        FailableBiConsumer failableBiConsumer2 = failableBiConsumer;
        Failable.run(failableBiConsumer2, () -> failableBiConsumer2.accept(t2, u2));
    }

    public static <T, E extends Throwable> void accept(FailableConsumer<T, E> failableConsumer, T t2) {
        FailableConsumer failableConsumer2 = failableConsumer;
        Failable.run(failableConsumer2, () -> failableConsumer2.accept(t2));
    }

    public static <E extends Throwable> void accept(FailableDoubleConsumer<E> failableDoubleConsumer, double d2) {
        FailableDoubleConsumer failableDoubleConsumer2 = failableDoubleConsumer;
        Failable.run(failableDoubleConsumer2, () -> failableDoubleConsumer2.accept(d2));
    }

    public static <E extends Throwable> void accept(FailableIntConsumer<E> failableIntConsumer, int n2) {
        FailableIntConsumer failableIntConsumer2 = failableIntConsumer;
        Failable.run(failableIntConsumer2, () -> failableIntConsumer2.accept(n2));
    }

    public static <E extends Throwable> void accept(FailableLongConsumer<E> failableLongConsumer, long l2) {
        FailableLongConsumer failableLongConsumer2 = failableLongConsumer;
        Failable.run(failableLongConsumer2, () -> failableLongConsumer2.accept(l2));
    }

    public static <T, U, R, E extends Throwable> R apply(FailableBiFunction<T, U, R, E> failableBiFunction, T t2, U u2) {
        return (R)Failable.get(() -> failableBiFunction.apply(t2, u2));
    }

    public static <T, R, E extends Throwable> R apply(FailableFunction<T, R, E> failableFunction, T t2) {
        return (R)Failable.get(() -> failableFunction.apply(t2));
    }

    public static <E extends Throwable> double applyAsDouble(FailableDoubleBinaryOperator<E> failableDoubleBinaryOperator, double d2, double d3) {
        return Failable.getAsDouble(() -> failableDoubleBinaryOperator.applyAsDouble(d2, d3));
    }

    public static <T, R, E extends Throwable> R applyNonNull(T t2, FailableFunction<? super T, ? extends R, E> failableFunction) throws E {
        if (t2 != null) {
            return Objects.requireNonNull(failableFunction, "mapper").apply(t2);
        }
        return null;
    }

    public static <T, U, R, E1 extends Throwable, E2 extends Throwable> R applyNonNull(T t2, FailableFunction<? super T, ? extends U, E1> failableFunction, FailableFunction<? super U, ? extends R, E2> failableFunction2) throws E1, E2 {
        return Failable.applyNonNull(Failable.applyNonNull(t2, failableFunction), failableFunction2);
    }

    public static <T, U, V, R, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> R applyNonNull(T t2, FailableFunction<? super T, ? extends U, E1> failableFunction, FailableFunction<? super U, ? extends V, E2> failableFunction2, FailableFunction<? super V, ? extends R, E3> failableFunction3) throws E1, E2, E3 {
        return Failable.applyNonNull(Failable.applyNonNull(Failable.applyNonNull(t2, failableFunction), failableFunction2), failableFunction3);
    }

    public static <T, U> BiConsumer<T, U> asBiConsumer(FailableBiConsumer<T, U, ?> failableBiConsumer) {
        return (object, object2) -> Failable.accept(failableBiConsumer, object, object2);
    }

    public static <T, U, R> BiFunction<T, U, R> asBiFunction(FailableBiFunction<T, U, R, ?> failableBiFunction) {
        return (object, object2) -> Failable.apply(failableBiFunction, object, object2);
    }

    public static <T, U> BiPredicate<T, U> asBiPredicate(FailableBiPredicate<T, U, ?> failableBiPredicate) {
        return (object, object2) -> Failable.test(failableBiPredicate, object, object2);
    }

    public static <V> Callable<V> asCallable(FailableCallable<V, ?> failableCallable) {
        return () -> Failable.call(failableCallable);
    }

    public static <T> Consumer<T> asConsumer(FailableConsumer<T, ?> failableConsumer) {
        return object -> Failable.accept(failableConsumer, object);
    }

    public static <T, R> Function<T, R> asFunction(FailableFunction<T, R, ?> failableFunction) {
        return object -> Failable.apply(failableFunction, object);
    }

    public static <T> Predicate<T> asPredicate(FailablePredicate<T, ?> failablePredicate) {
        return object -> Failable.test(failablePredicate, object);
    }

    public static Runnable asRunnable(FailableRunnable<?> failableRunnable) {
        return () -> Failable.run(failableRunnable);
    }

    public static <T> Supplier<T> asSupplier(FailableSupplier<T, ?> failableSupplier) {
        return () -> Failable.get(failableSupplier);
    }

    public static <V, E extends Throwable> V call(FailableCallable<V, E> failableCallable) {
        return (V)Failable.get(failableCallable::call);
    }

    public static <T, E extends Throwable> T get(FailableSupplier<T, E> object) {
        try {
            return object.get();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw Failable.rethrow(throwable);
        }
    }

    public static <E extends Throwable> boolean getAsBoolean(FailableBooleanSupplier<E> object) {
        try {
            return object.getAsBoolean();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw Failable.rethrow(throwable);
        }
    }

    public static <E extends Throwable> double getAsDouble(FailableDoubleSupplier<E> object) {
        try {
            return object.getAsDouble();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw Failable.rethrow(throwable);
        }
    }

    public static <E extends Throwable> int getAsInt(FailableIntSupplier<E> object) {
        try {
            return object.getAsInt();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw Failable.rethrow(throwable);
        }
    }

    public static <E extends Throwable> long getAsLong(FailableLongSupplier<E> object) {
        try {
            return object.getAsLong();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw Failable.rethrow(throwable);
        }
    }

    public static <E extends Throwable> short getAsShort(FailableShortSupplier<E> object) {
        try {
            return object.getAsShort();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw Failable.rethrow(throwable);
        }
    }

    public static RuntimeException rethrow(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable");
        ExceptionUtils.throwUnchecked(throwable);
        if (throwable instanceof IOException) {
            throw new UncheckedIOException((IOException)throwable);
        }
        throw new UndeclaredThrowableException(throwable);
    }

    public static <E extends Throwable> void run(FailableRunnable<E> object) {
        if (object != null) {
            try {
                object.run();
                return;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw Failable.rethrow(throwable);
            }
        }
    }

    private static <E extends Throwable> void run(Object object, FailableRunnable<E> failableRunnable) {
        if (failableRunnable != null && object != null) {
            try {
                failableRunnable.run();
                return;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw Failable.rethrow(throwable);
            }
        }
    }

    public static <E> Streams$FailableStream<E> stream(Collection<E> collection) {
        return new Streams$FailableStream<E>(collection.stream());
    }

    public static <T> Streams$FailableStream<T> stream(Stream<T> stream) {
        return new Streams$FailableStream<T>(stream);
    }

    public static <T, U, E extends Throwable> boolean test(FailableBiPredicate<T, U, E> failableBiPredicate, T t2, U u2) {
        return Failable.getAsBoolean(() -> failableBiPredicate.test(t2, u2));
    }

    public static <T, E extends Throwable> boolean test(FailablePredicate<T, E> failablePredicate, T t2) {
        return Failable.getAsBoolean(() -> failablePredicate.test(t2));
    }

    @SafeVarargs
    public static void tryWithResources(FailableRunnable<? extends Throwable> object, FailableConsumer<Throwable, ? extends Throwable> failableConsumer, FailableRunnable<? extends Throwable> ... failableRunnableArray) {
        if (failableConsumer == null) {
            failableConsumer = Failable::rethrow;
        }
        Streams.of(failableRunnableArray).forEach(failableRunnable -> Objects.requireNonNull(failableRunnable, "runnable"));
        Throwable throwable = null;
        try {
            object.run();
        }
        catch (Throwable throwable2) {
            object = throwable2;
            throwable = throwable2;
        }
        if (failableRunnableArray != null) {
            object = failableRunnableArray;
            int n2 = failableRunnableArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                FailableRunnable<? extends Throwable> failableRunnable2 = object[i2];
                try {
                    failableRunnable2.run();
                    continue;
                }
                catch (Throwable throwable3) {
                    if (throwable != null) continue;
                    throwable = throwable3;
                }
            }
        }
        if (throwable != null) {
            try {
                failableConsumer.accept(throwable);
                return;
            }
            catch (Throwable throwable4) {
                object = throwable4;
                throw Failable.rethrow(throwable4);
            }
        }
    }

    @SafeVarargs
    public static void tryWithResources(FailableRunnable<? extends Throwable> failableRunnable, FailableRunnable<? extends Throwable> ... failableRunnableArray) {
        Failable.tryWithResources(failableRunnable, null, failableRunnableArray);
    }

    private Failable() {
    }
}

