/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import java.io.Serializable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.mutable.Mutable;

public class MutableBoolean
implements Serializable,
Comparable<MutableBoolean>,
Mutable<Boolean> {
    private static final long serialVersionUID = -4830728138360036487L;
    private boolean value;

    public MutableBoolean() {
    }

    public MutableBoolean(boolean bl2) {
        this.value = bl2;
    }

    public MutableBoolean(Boolean bl2) {
        this.value = bl2;
    }

    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public int compareTo(MutableBoolean mutableBoolean) {
        return BooleanUtils.compare(this.value, mutableBoolean.value);
    }

    public boolean equals(Object object) {
        if (object instanceof MutableBoolean) {
            return this.value == ((MutableBoolean)object).booleanValue();
        }
        return false;
    }

    @Override
    @Deprecated
    public Boolean getValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.value) {
            return Boolean.TRUE.hashCode();
        }
        return Boolean.FALSE.hashCode();
    }

    public boolean isFalse() {
        return !this.value;
    }

    public boolean isTrue() {
        return this.value;
    }

    public void setFalse() {
        this.value = false;
    }

    public void setTrue() {
        this.value = true;
    }

    @Override
    public void setValue(boolean bl2) {
        this.value = bl2;
    }

    @Override
    public void setValue(Boolean bl2) {
        this.value = bl2;
    }

    public Boolean toBoolean() {
        return this.booleanValue();
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

