/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.Mutable;

public class MutableLong
extends Number
implements Comparable<MutableLong>,
Mutable<Number> {
    private static final long serialVersionUID = 62986528375L;
    private long value;

    public MutableLong() {
    }

    public MutableLong(long l2) {
        this.value = l2;
    }

    public MutableLong(Number number) {
        this.value = number.longValue();
    }

    public MutableLong(String string) {
        this.value = Long.parseLong(string);
    }

    public void add(long l2) {
        this.value += l2;
    }

    public void add(Number number) {
        this.value += number.longValue();
    }

    public long addAndGet(long l2) {
        this.value += l2;
        return this.value;
    }

    public long addAndGet(Number number) {
        this.value += number.longValue();
        return this.value;
    }

    @Override
    public int compareTo(MutableLong mutableLong) {
        return Long.compare(this.value, mutableLong.value);
    }

    public void decrement() {
        --this.value;
    }

    public long decrementAndGet() {
        --this.value;
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof MutableLong) {
            return this.value == ((MutableLong)object).longValue();
        }
        return false;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public long getAndAdd(long l2) {
        long l3 = this.value;
        this.value += l2;
        return l3;
    }

    public long getAndAdd(Number number) {
        long l2 = this.value;
        this.value += number.longValue();
        return l2;
    }

    public long getAndDecrement() {
        long l2 = this.value--;
        return l2;
    }

    public long getAndIncrement() {
        long l2 = this.value++;
        return l2;
    }

    @Override
    @Deprecated
    public Long getValue() {
        return this.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public void increment() {
        ++this.value;
    }

    public long incrementAndGet() {
        ++this.value;
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public void setValue(long l2) {
        this.value = l2;
    }

    @Override
    public void setValue(Number number) {
        this.value = number.longValue();
    }

    public void subtract(long l2) {
        this.value -= l2;
    }

    public void subtract(Number number) {
        this.value -= number.longValue();
    }

    public Long toLong() {
        return this.longValue();
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

