/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.AccessibleObjects;
import org.apache.commons.lang3.reflect.MemberUtils$Executable;

final class MemberUtils {
    private static final int ACCESS_TEST = 7;
    private static final Class<?>[] WIDENING_PRIMITIVE_TYPES = new Class[]{Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};

    MemberUtils() {
    }

    static int compareConstructorFit(Constructor<?> constructor, Constructor<?> constructor2, Class<?>[] classArray) {
        return MemberUtils.compareParameterTypes(MemberUtils$Executable.access$000(constructor), MemberUtils$Executable.access$000(constructor2), classArray);
    }

    static int compareMethodFit(Method method, Method method2, Class<?>[] classArray) {
        return MemberUtils.compareParameterTypes(MemberUtils$Executable.access$100(method), MemberUtils$Executable.access$100(method2), classArray);
    }

    private static int compareParameterTypes(MemberUtils$Executable memberUtils$Executable, MemberUtils$Executable memberUtils$Executable2, Class<?>[] classArray) {
        float f2 = MemberUtils.getTotalTransformationCost(classArray, memberUtils$Executable);
        float f3 = MemberUtils.getTotalTransformationCost(classArray, memberUtils$Executable2);
        return Float.compare(f2, f3);
    }

    private static float getObjectTransformationCost(Class<?> clazz, Class<?> clazz2) {
        if (clazz2.isPrimitive()) {
            return MemberUtils.getPrimitivePromotionCost(clazz, clazz2);
        }
        float f2 = 0.0f;
        while (clazz != null && !clazz2.equals(clazz)) {
            if (clazz2.isInterface() && ClassUtils.isAssignable(clazz, clazz2)) {
                f2 += 0.25f;
                break;
            }
            f2 += 1.0f;
            clazz = clazz.getSuperclass();
        }
        if (clazz == null) {
            f2 += 1.5f;
        }
        return f2;
    }

    private static float getPrimitivePromotionCost(Class<?> clazz, Class<?> clazz2) {
        if (clazz == null) {
            return 1.5f;
        }
        float f2 = 0.0f;
        if (!clazz.isPrimitive()) {
            f2 = 0.1f;
            clazz = ClassUtils.wrapperToPrimitive(clazz);
        }
        for (int i2 = 0; clazz != clazz2 && i2 < WIDENING_PRIMITIVE_TYPES.length; ++i2) {
            if (clazz != WIDENING_PRIMITIVE_TYPES[i2]) continue;
            f2 += 0.1f;
            if (i2 >= WIDENING_PRIMITIVE_TYPES.length - 1) continue;
            clazz = WIDENING_PRIMITIVE_TYPES[i2 + 1];
        }
        return f2;
    }

    private static float getTotalTransformationCost(Class<?>[] classArray, MemberUtils$Executable memberUtils$Executable) {
        long l2;
        Object object = memberUtils$Executable.getParameterTypes();
        int n2 = memberUtils$Executable.isVarArgs();
        float f2 = 0.0f;
        long l3 = l2 = n2 != 0 ? (long)(((Class<?>[])object).length - 1) : (long)((Class<?>[])object).length;
        if ((long)classArray.length < l2) {
            return Float.MAX_VALUE;
        }
        int n3 = 0;
        while ((long)n3 < l2) {
            f2 += MemberUtils.getObjectTransformationCost(classArray[n3], object[n3]);
            ++n3;
        }
        if (n2 != 0) {
            n3 = classArray.length < ((Class<?>[])object).length ? 1 : 0;
            n2 = classArray.length == ((Class<?>[])object).length && classArray[classArray.length - 1] != null && classArray[classArray.length - 1].isArray() ? 1 : 0;
            Class<?> clazz = object[((Class<?>[])object).length - 1].getComponentType();
            if (n3 != 0) {
                f2 += MemberUtils.getObjectTransformationCost(clazz, Object.class) + 0.001f;
            } else if (n2 != 0) {
                Class<?> clazz2 = classArray[classArray.length - 1].getComponentType();
                f2 += MemberUtils.getObjectTransformationCost(clazz2, clazz) + 0.001f;
            } else {
                for (n2 = ((Class<?>[])object).length - 1; n2 < classArray.length; ++n2) {
                    object = classArray[n2];
                    f2 += MemberUtils.getObjectTransformationCost(object, clazz) + 0.001f;
                }
            }
        }
        return f2;
    }

    static boolean isAccessible(Member member) {
        return MemberUtils.isPublic(member) && !member.isSynthetic();
    }

    static boolean isMatchingConstructor(Constructor<?> constructor, Class<?>[] classArray) {
        return MemberUtils.isMatchingExecutable(MemberUtils$Executable.access$000(constructor), classArray);
    }

    private static boolean isMatchingExecutable(MemberUtils$Executable memberUtils$Executable, Class<?>[] classArray) {
        Object object = memberUtils$Executable.getParameterTypes();
        if (ClassUtils.isAssignable(classArray, object, true)) {
            return true;
        }
        if (memberUtils$Executable.isVarArgs()) {
            int n2;
            for (n2 = 0; n2 < ((Class<?>[])object).length - 1 && n2 < classArray.length; ++n2) {
                if (ClassUtils.isAssignable(classArray[n2], object[n2], true)) continue;
                return false;
            }
            object = object[((Class<?>[])object).length - 1].getComponentType();
            while (n2 < classArray.length) {
                if (!ClassUtils.isAssignable(classArray[n2], object, true)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    static boolean isMatchingMethod(Method method, Class<?>[] classArray) {
        return MemberUtils.isMatchingExecutable(MemberUtils$Executable.access$100(method), classArray);
    }

    static boolean isPackage(int n2) {
        return (n2 & 7) == 0;
    }

    static boolean isPublic(Member member) {
        return member != null && Modifier.isPublic(member.getModifiers());
    }

    static boolean isStatic(Member member) {
        return member != null && Modifier.isStatic(member.getModifiers());
    }

    static <T extends AccessibleObject> T setAccessibleWorkaround(T t2) {
        if (AccessibleObjects.isAccessible(t2)) {
            return t2;
        }
        Member member = (Member)((Object)t2);
        if (MemberUtils.isPublic(member) && MemberUtils.isPackage(member.getDeclaringClass().getModifiers())) {
            try {
                t2.setAccessible(true);
                return t2;
            }
            catch (SecurityException securityException) {}
        }
        return t2;
    }
}

