/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.stream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.apache.commons.lang3.ArrayUtils;

public class Streams$ArrayCollector<E>
implements Collector<E, List<E>, E[]> {
    private static final Set<Collector.Characteristics> characteristics = Collections.emptySet();
    private final Class<E> elementType;

    public Streams$ArrayCollector(Class<E> clazz) {
        this.elementType = Objects.requireNonNull(clazz, "elementType");
    }

    @Override
    public BiConsumer<List<E>, E> accumulator() {
        return List::add;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return characteristics;
    }

    @Override
    public BinaryOperator<List<E>> combiner() {
        return (list, list2) -> {
            list.addAll(list2);
            return list;
        };
    }

    @Override
    public Function<List<E>, E[]> finisher() {
        return list -> list.toArray(ArrayUtils.newInstance(this.elementType, list.size()));
    }

    @Override
    public Supplier<List<E>> supplier() {
        return ArrayList::new;
    }
}

