/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.stream;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.stream.Streams$ArrayCollector;
import org.apache.commons.lang3.stream.Streams$EnumerationSpliterator;
import org.apache.commons.lang3.stream.Streams$FailableStream;

public class Streams {
    public static <T> Streams$FailableStream<T> failableStream(Collection<T> collection) {
        return Streams.failableStream(Streams.of(collection));
    }

    public static <T> Streams$FailableStream<T> failableStream(Stream<T> stream) {
        return new Streams$FailableStream<T>(stream);
    }

    public static <T> Streams$FailableStream<T> failableStream(T t2) {
        return Streams.failableStream(Streams.streamOf(t2));
    }

    @SafeVarargs
    public static <T> Streams$FailableStream<T> failableStream(T ... TArray) {
        return Streams.failableStream(Streams.of(TArray));
    }

    public static <E> Stream<E> instancesOf(Class<? super E> clazz, Collection<? super E> collection) {
        return Streams.instancesOf(clazz, Streams.of(collection));
    }

    private static <E> Stream<E> instancesOf(Class<? super E> clazz, Stream<?> stream) {
        return Streams.of(stream).filter(clazz::isInstance);
    }

    public static <E> Stream<E> nonNull(Collection<E> collection) {
        return Streams.of(collection).filter(Objects::nonNull);
    }

    public static <E> Stream<E> nonNull(E e2) {
        return Streams.nonNull(Streams.streamOf(e2));
    }

    @SafeVarargs
    public static <E> Stream<E> nonNull(E ... EArray) {
        return Streams.nonNull(Streams.of(EArray));
    }

    public static <E> Stream<E> nonNull(Stream<E> stream) {
        return Streams.of(stream).filter(Objects::nonNull);
    }

    public static <E> Stream<E> of(Collection<E> collection) {
        if (collection == null) {
            return Stream.empty();
        }
        return collection.stream();
    }

    public static <E> Stream<E> of(Enumeration<E> enumeration) {
        return StreamSupport.stream(new Streams$EnumerationSpliterator<E>(Long.MAX_VALUE, 16, enumeration), false);
    }

    public static <E> Stream<E> of(Iterable<E> iterable) {
        if (iterable == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <E> Stream<E> of(Iterator<E> iterator) {
        if (iterator == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    private static <E> Stream<E> of(Stream<E> stream) {
        if (stream == null) {
            return Stream.empty();
        }
        return stream;
    }

    @SafeVarargs
    public static <T> Stream<T> of(T ... TArray) {
        if (TArray == null) {
            return Stream.empty();
        }
        return Stream.of(TArray);
    }

    @Deprecated
    public static <E> Streams$FailableStream<E> stream(Collection<E> collection) {
        return Streams.failableStream(collection);
    }

    @Deprecated
    public static <T> Streams$FailableStream<T> stream(Stream<T> stream) {
        return Streams.failableStream(stream);
    }

    private static <T> Stream<T> streamOf(T t2) {
        if (t2 == null) {
            return Stream.empty();
        }
        return Stream.of(t2);
    }

    public static <T> Collector<T, List<T>, T[]> toArray(Class<T> clazz) {
        return new Streams$ArrayCollector<T>(clazz);
    }

    @Deprecated
    public Streams() {
    }
}

